/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial.plots;

import edu.cens.spatial.AcceptSubsetDialog;
import edu.cens.spatial.plots.MapPanel;
import edu.cens.spatial.plots.SpatialPlotBuilder;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapController;
import org.openstreetmap.gui.jmapviewer.JMapViewer;

public class MapController
extends JMapController
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
ActionListener,
ChangeListener {
    protected static final int MOUSE_BUTTONS_MASK = 7168;
    protected static final int MAC_MOUSE_BUTTON3_MASK = 1152;
    protected SpatialPlotBuilder builder;
    protected Point lastDragPoint;
    protected boolean isMoving = false;
    protected boolean movementEnabled = true;
    protected int movementMouseButton = 1;
    protected int movementMouseButtonMask = 1024;
    protected boolean wheelZoomEnabled = true;
    protected boolean doubleClickZoomEnabled = true;
    SubsetBoxState subsetBoxState = SubsetBoxState.DISABLED;
    Coordinate subsetCorner1;
    Coordinate subsetCorner2;

    public MapController(JMapViewer jMapViewer) {
        super(jMapViewer);
    }

    public MapController(JMapViewer jMapViewer, SpatialPlotBuilder spatialPlotBuilder) {
        super(jMapViewer);
        this.builder = spatialPlotBuilder;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.movementEnabled || !this.isMoving) {
            return;
        }
        if ((mouseEvent.getModifiersEx() & 0x1C00) == this.movementMouseButtonMask && this.subsetBoxState != SubsetBoxState.DRAGGING) {
            Point point = mouseEvent.getPoint();
            if (this.lastDragPoint != null) {
                int n = this.lastDragPoint.x - point.x;
                int n2 = this.lastDragPoint.y - point.y;
                this.map.moveMap(n, n2);
                this.builder.updatePlot();
            }
            this.lastDragPoint = point;
        }
        if (this.subsetBoxState == SubsetBoxState.DRAGGING || this.subsetBoxState == SubsetBoxState.ACCEPT_DIALOG) {
            if (this.subsetBoxState == SubsetBoxState.DRAGGING) {
                this.subsetCorner2 = this.map.getPosition(mouseEvent.getPoint());
            }
            if (mouseEvent.getPoint() != null) {
                ((MapPanel)this.map).drawSubsetRectangle(this.subsetCorner1, this.subsetCorner2, this.subsetBoxState == SubsetBoxState.DRAGGING);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (MapController.isPlatformOsx()) {
            // empty if block
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.doubleClickZoomEnabled && mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
            this.map.zoomIn(mouseEvent.getPoint());
            this.builder.updatePlot();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == this.movementMouseButton || MapController.isPlatformOsx() && mouseEvent.getModifiersEx() == 1152) {
            this.lastDragPoint = null;
            this.isMoving = true;
            if (this.subsetBoxState == SubsetBoxState.READY) {
                this.subsetCorner1 = this.map.getPosition(mouseEvent.getPoint());
                this.subsetBoxState = SubsetBoxState.DRAGGING;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == this.movementMouseButton || MapController.isPlatformOsx() && mouseEvent.getButton() == 1) {
            this.lastDragPoint = null;
            this.isMoving = false;
            this.builder.setCursorNormal();
            if (this.subsetBoxState == SubsetBoxState.DRAGGING) {
                this.subsetBoxState = SubsetBoxState.ACCEPT_DIALOG;
                new AcceptSubsetDialog((JFrame)((Object)this.builder), this).setVisible(true);
            }
            this.builder.updatePlot();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.doZoom(((MapPanel)this.map).getZoomSliderLevel(), null);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.wheelZoomEnabled) {
            this.doZoom(this.map.getZoom() - mouseWheelEvent.getWheelRotation(), mouseWheelEvent.getPoint());
        }
    }

    private void doZoom(int n, Point point) {
        this.map.setZoom(n, point);
        this.builder.updatePlot();
        if (this.subsetBoxState != SubsetBoxState.DISABLED) {
            ((MapPanel)this.map).drawSubsetRectangle(this.subsetCorner1, this.subsetCorner2, false);
        }
    }

    public void addListenersTo(Component component) {
        if (this instanceof MouseListener) {
            component.addMouseListener(this);
        }
        if (this instanceof MouseWheelListener) {
            component.addMouseWheelListener(this);
        }
        if (this instanceof MouseMotionListener) {
            component.addMouseMotionListener(this);
        }
    }

    public boolean isMovementEnabled() {
        return this.movementEnabled;
    }

    public void setMovementEnabled(boolean bl) {
        this.movementEnabled = bl;
    }

    public int getMovementMouseButton() {
        return this.movementMouseButton;
    }

    public void setMovementMouseButton(int n) {
        this.movementMouseButton = n;
        switch (n) {
            case 1: {
                this.movementMouseButtonMask = 1024;
                break;
            }
            case 2: {
                this.movementMouseButtonMask = 2048;
                break;
            }
            case 3: {
                this.movementMouseButtonMask = 4096;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported button");
            }
        }
    }

    public boolean isWheelZoomEnabled() {
        return this.wheelZoomEnabled;
    }

    public void setWheelZoomEnabled(boolean bl) {
        this.wheelZoomEnabled = bl;
    }

    public boolean isDoubleClickZoomEnabled() {
        return this.doubleClickZoomEnabled;
    }

    public void setDoubleClickZoomEnabled(boolean bl) {
        this.doubleClickZoomEnabled = bl;
    }

    public static boolean isPlatformOsx() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().startsWith("mac os x");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("in")) {
            this.map.zoomIn();
            this.builder.updatePlot();
        } else if (string.equals("out")) {
            this.map.zoomOut();
            this.builder.updatePlot();
        }
    }

    public void startSubsetting() {
        this.subsetBoxState = SubsetBoxState.READY;
    }

    public boolean executeSubsetting(boolean bl, String string) {
        double d;
        double d2;
        double d3;
        double d4 = Math.min(this.subsetCorner1.getLat(), this.subsetCorner2.getLat());
        boolean bl2 = this.builder.executeSubsetting(d4, d3 = Math.min(this.subsetCorner1.getLon(), this.subsetCorner2.getLon()), d2 = Math.max(this.subsetCorner1.getLat(), this.subsetCorner2.getLat()), d = Math.max(this.subsetCorner1.getLon(), this.subsetCorner2.getLon()), bl, string);
        if (bl2) {
            this.subsetBoxState = SubsetBoxState.DISABLED;
            ((MapPanel)this.map).clearSubsetRectangle();
            this.map.repaint();
        }
        return bl2;
    }

    public void stopSubsetting() {
        this.subsetBoxState = SubsetBoxState.DISABLED;
        ((MapPanel)this.map).clearSubsetRectangle();
        this.builder.stopSubsetting();
        this.map.repaint();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SubsetBoxState {
        DISABLED,
        READY,
        DRAGGING,
        ACCEPT_DIALOG;

    }
}

