/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractOsmTileSource;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BingAerialTileSource
extends AbstractOsmTileSource {
    private static String API_KEY = "Arzdiw4nlOJzRwOz__qailc8NiR31Tt51dN2D7cm57NrnceZnCpgOkmJhNpGoppU";
    private static Future<List<Attribution>> attributions;

    public BingAerialTileSource() {
        super("Bing Aerial Maps", "http://ecn.t2.tiles.virtualearth.net/tiles/");
        if (attributions == null) {
            attributions = Executors.newSingleThreadExecutor().submit(new Callable<List<Attribution>>(){

                @Override
                public List<Attribution> call() throws Exception {
                    return BingAerialTileSource.this.loadAttributionText();
                }
            });
        }
    }

    private List<Attribution> loadAttributionText() {
        try {
            URL u = new URL("http://dev.virtualearth.net/REST/v1/Imagery/Metadata/Aerial/0,0?zl=1&mapVersion=v1&key=" + API_KEY + "&include=ImageryProviders&output=xml");
            URLConnection conn = u.openConnection();
            InputStream stream = conn.getInputStream();
            XMLReader parser = XMLReaderFactory.createXMLReader();
            AttrHandler handler = new AttrHandler();
            parser.setContentHandler(handler);
            parser.parse(new InputSource(stream));
            return handler.attributions;
        }
        catch (IOException e) {
            System.err.println("Could not open Bing aerials attribution metadata.");
        }
        catch (SAXException e) {
            System.err.println("Could not parse Bing aerials attribution metadata.");
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public int getMaxZoom() {
        return 22;
    }

    @Override
    public String getExtension() {
        return "jpeg";
    }

    @Override
    public String getTilePath(int zoom, int tilex, int tiley) throws IOException {
        try {
            if (attributions.get() == null) {
                throw new IOException("Cannot load Bing attribution");
            }
            String quadtree = BingAerialTileSource.computeQuadTree(zoom, tilex, tiley);
            return "/tiles/a" + quadtree + "." + this.getExtension() + "?g=587";
        }
        catch (Exception e) {
            throw new IOException("Cannot load Bing attribution", e);
        }
    }

    @Override
    public TileSource.TileUpdate getTileUpdate() {
        return TileSource.TileUpdate.IfNoneMatch;
    }

    @Override
    public boolean requiresAttribution() {
        return true;
    }

    @Override
    public Image getAttributionImage() {
        try {
            return ImageIO.read(this.getClass().getResourceAsStream("images/bing_maps.png"));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getAttributionLinkURL() {
        return "http://go.microsoft.com/?linkid=9710837";
    }

    @Override
    public String getTermsOfUseURL() {
        return "http://opengeodata.org/microsoft-imagery-details";
    }

    @Override
    public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
        try {
            if (!attributions.isDone()) {
                return "Loading Bing attribution data...";
            }
            if (attributions.get() == null) {
                return "Error loading Bing attribution data";
            }
            StringBuilder a = new StringBuilder();
            for (Attribution attr : attributions.get()) {
                if (zoom > attr.maxZoom || zoom < attr.minZoom || !(topLeft.getLon() < attr.max.getLon()) || !(botRight.getLon() > attr.min.getLon()) || !(topLeft.getLat() > attr.min.getLat()) || !(botRight.getLat() < attr.max.getLat())) continue;
                a.append(attr.attribution);
                a.append(" ");
            }
            return a.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error loading Bing attribution data";
        }
    }

    static String computeQuadTree(int zoom, int tilex, int tiley) {
        StringBuilder k = new StringBuilder();
        for (int i = zoom; i > 0; --i) {
            char digit = '0';
            int mask = 1 << i - 1;
            if ((tilex & mask) != 0) {
                digit = (char)(digit + 1);
            }
            if ((tiley & mask) != 0) {
                digit = (char)(digit + 2);
            }
            k.append(digit);
        }
        return k.toString();
    }

    class AttrHandler
    extends DefaultHandler {
        private String string;
        private Attribution curr;
        private List<Attribution> attributions = new ArrayList<Attribution>();
        private double southLat;
        private double northLat;
        private double eastLon;
        private double westLon;
        private boolean inCoverage = false;

        AttrHandler() {
        }

        public void startElement(String uri, String stripped, String tagName, Attributes attrs) throws SAXException {
            if ("ImageryProvider".equals(tagName)) {
                this.curr = new Attribution();
            } else if ("CoverageArea".equals(tagName)) {
                this.inCoverage = true;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.string = new String(ch, start, length);
        }

        public void endElement(String uri, String stripped, String tagName) throws SAXException {
            if ("ImageryProvider".equals(tagName)) {
                this.attributions.add(this.curr);
            } else if ("Attribution".equals(tagName)) {
                this.curr.attribution = this.string;
            } else if (this.inCoverage && "ZoomMin".equals(tagName)) {
                this.curr.minZoom = Integer.parseInt(this.string);
            } else if (this.inCoverage && "ZoomMax".equals(tagName)) {
                this.curr.maxZoom = Integer.parseInt(this.string);
            } else if (this.inCoverage && "SouthLatitude".equals(tagName)) {
                this.southLat = Double.parseDouble(this.string);
            } else if (this.inCoverage && "NorthLatitude".equals(tagName)) {
                this.northLat = Double.parseDouble(this.string);
            } else if (this.inCoverage && "EastLongitude".equals(tagName)) {
                this.eastLon = Double.parseDouble(this.string);
            } else if (this.inCoverage && "WestLongitude".equals(tagName)) {
                this.westLon = Double.parseDouble(this.string);
            } else if ("BoundingBox".equals(tagName)) {
                this.curr.min = new Coordinate(this.southLat, this.westLon);
                this.curr.max = new Coordinate(this.northLat, this.eastLon);
            } else if ("CoverageArea".equals(tagName)) {
                this.inCoverage = false;
            }
            this.string = "";
        }
    }

    class Attribution {
        String attribution;
        int minZoom;
        int maxZoom;
        Coordinate min;
        Coordinate max;

        Attribution() {
        }
    }
}

