% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Delta.R, R/print.Delta.R, R/summary.Delta.R
\name{Delta}
\alias{Delta}
\alias{print.Delta}
\alias{summary.Delta}
\title{Delta coefficient function}
\usage{
Delta(datatable, fixedrows = FALSE, gstandard = "No", maxits = 1000,
  tol = 1e-12, dplaces = 4, showall = FALSE)

\method{print}{Delta}(x, ...)

\method{summary}{Delta}(object, ...)
}
\arguments{
\item{datatable}{Matrix. Expected to be square matrix with at least 2 rows (columns), non negative values and at least an element different of zero.}

\item{fixedrows}{Boolean. Indicate if sample rows are fixed beforehand. Default is TRUE.}

\item{gstandard}{Text. Indicate if there are a Gold Standard by Rows or columns. Only first letter matter without Case sensitivity. Options are: "N" for None, "R" for in Rows and "C" for in Columns. Default is "N".}

\item{maxits}{Whole number. Indicate the maximum number of iterations of the numeric method to calculate B. Expected to be 100 <= maxits <= 5000. Default is 1000.}

\item{tol}{Double number. Indicate the precision of the numeric method to calculate B. Expected to be 1e-6 <= tol <= 1e-15.Default is 1e-12.}

\item{dplaces}{Whole number. Decimal placed to be shown in the result. Expected to be 1 <= dplaces <0 6. Default 4.}

\item{showall}{Boolean. Indicate if all output should be shown. If TRUE also shown hidden results. If FALSE shown only main output. By default is FALSE.}

\item{x}{List produced by Delta}

\item{...}{Other print options}

\item{object}{List produced by Delta}
}
\value{
\code{NULL}

\code{NULL}
}
\description{
This function provides an analysis of the matrix provided, returning all all the parameters estimations
and SE calculations that have sense with the fixedrows and gstandard provided.
}
\details{
This function study the matrix provided by the user. This function modify the matrix deleting missing rows and columns and 
if it is needed for the estimation, adding 0.5 to each cell.

Also calculate Cohen's Kappa coefficient and the goodness of fit for the Delta model.
}
\examples{
Delta(matrix(c(1,2,3,4),2,2))
Delta(matrix(c(65,5,10,20),2,2),fixedrows=TRUE,gstandard="Row")
}
\keyword{Delta}
\keyword{datatable}
\keyword{dplaces}
\keyword{fixedrows}
\keyword{gstandard}
\keyword{maxits}
\keyword{tol}
