% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_node_attr_in_selection.R
\name{rescale_node_attr_in_selection}
\alias{rescale_node_attr_in_selection}
\title{Rescale numeric node attribute values for nodes in a selection}
\usage{
rescale_node_attr_in_selection(graph, node_attr_from, node_attr_to,
  to_lower_bound = 0, to_upper_bound = 1, from_lower_bound = NULL,
  from_upper_bound = NULL)
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph} that is created using
\code{create_graph}.}

\item{node_attr_from}{the node attribute containing numeric data that
is to be rescaled to new numeric or color values.}

\item{node_attr_to}{the name of the new or existing node attribute that
will contain the scaled values. If the node attribute exists for the
selected nodes, rescaled values will replace any existing values.}

\item{to_lower_bound}{the lower bound value for the set of rescaled
values. This can be a numeric value or an X11 color name.}

\item{to_upper_bound}{the upper bound value for the set of rescaled
values. This can be a numeric value or an X11 color name.}

\item{from_lower_bound}{an optional, manually set lower bound value for
the set of values to be rescaled. If not set, the minimum value of the set of
values to be rescaled will be used.}

\item{from_upper_bound}{an optional, manually set upper bound value for
the set of values to be rescaled. If not set, the minimum value of the set of
values to be rescaled will be used.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph}, take a set of
numeric values for node attributes specified in a selection of nodes,
rescale to a new numeric or color range, then write a new set of node
attribute values.
}

