% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_node_attrs.R
\name{cache_node_attrs}
\alias{cache_node_attrs}
\title{Cache node attributes in the graph}
\usage{
cache_node_attrs(graph, node_attr, name = NULL, mode = NULL, nodes = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{node_attr}{the node attribute from which to
obtain values.}

\item{name}{an optional name for the cached vector.}

\item{mode}{a option to recast the returned vector
of node attribute value as \code{numeric} or
\code{character}.}

\item{nodes}{an optional vector of node IDs for
filtering the list of nodes present in the graph.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class
\code{dgr_graph}, get node attribute properties for
one or more nodes and cache those values in the
graph for later retrieval using \code{get_cache}.
}
\examples{
# Set a seed
set.seed(23)

# Create a graph with 10 nodes and 9 edges
graph <-
  create_graph() \%>\%
  add_n_nodes(n = 10) \%>\%
  set_node_attrs(
    node_attr = value,
    values = rnorm(node_count(.), 5, 2)) \%>\%
  add_edges_w_string(
    edges =
      "1->2 1->3 2->4 2->5 3->6
       3->7 4->8 4->9 5->10")

# Cache all values from the node attribute `value`
# as a numeric vector
graph <-
  graph \%>\%
  cache_node_attrs(
    node_attr = value,
    name = "node_value")

# Get the mean from all values available in
# the cache
graph \%>\%
  get_cache(name = "node_value") \%>\%
  mean()
#> [1] 5.766209
}
