% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_edges.R
\name{get_edges}
\alias{get_edges}
\title{Get node IDs associated with edges}
\usage{
get_edges(x, conditions = NULL, return_type = "vector",
  return_values = "id")
}
\arguments{
\item{x}{either a graph object of class
\code{dgr_graph} or an edge data frame.}

\item{conditions}{an option to use filtering
conditions for the retrieval of edges.}

\item{return_type}{using \code{vector} (the
default), a vector of character objects
representing the edges is provided. With
\code{list} a list object will be provided that
contains vectors of outgoing and incoming node IDs
associated with edges. With \code{df}, a data frame
containing outgoing and incoming node IDs associated
with edges.}

\item{return_values}{using \code{id} (the default)
results in node ID values returned in the edge
definitions. With \code{label}, the node labels will
instead be used to define edges.}
}
\value{
a list, data frame, or a vector object,
depending on the value given to \code{return_type}.
}
\description{
Obtain a vector, data frame, or list of
node IDs from a graph object or an edge data frame.
An optional filter by edge attribute can limit the
set of edges returned.
}
\examples{
# Create a node data frame (ndf)
ndf <-
  create_node_df(
    n = 4,
    label = c("one", "two", "three", "four"),
    type = "letter",
    color = c("red", "green", "grey", "blue"),
    value = c(3.5, 2.6, 9.4, 2.7))

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
    to = c(4, 3, 1),
    rel = "leading_to",
    color = c("pink", "blue", "blue"),
    value = c(3.9, 2.5, 7.3))

# Create a graph
graph <-
  create_graph(
    nodes_df = ndf,
    edges_df = edf)

# Get all edges within a graph, returned as a list
get_edges(graph, return_type = "vector")
#> [1] "1->4" "2->3" "3->1"

# Get all edges within a graph, returned as a
# data frame
get_edges(graph, return_type = "df")
#>   from to
#> 1    1  4
#> 2    2  3
#> 3    3  1

# Get all edges returned as a list
get_edges(graph, return_type = "list")
#> [[1]]
#> [1] 1 2 3
#>
#> [[2]]
#> [1] 4 3 1

# Get a vector of edges using a numeric
# comparison (i.e., all edges with a `value`
# attribute greater than 3)
get_edges(
  graph,
  conditions = value > 3,
  return_type = "vector")
#> [1] "1->4" "3->1"

# Get a vector of edges using a match
get_edges(
  graph,
  conditions = color == "pink",
  return_type = "vector")
#> [1] "1->4"

# Use multiple conditions to return edges
# with the desired attribute values
get_edges(
  graph,
  conditions =
    color == "blue" &
    value > 3,
  return_type = "vector")
#> [1] "3->1"

# Use `return_values = "label"` to return
# the labels of the connected nodes
get_edges(
  graph,
  conditions =
    color == "blue" &
    value > 3,
  return_type = "vector",
  return_values = "label")
#> [1] "three->one"
}
