% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_edges_w_string.R
\name{add_edges_w_string}
\alias{add_edges_w_string}
\title{Add one or more edges using a text string}
\usage{
add_edges_w_string(graph, edges, rel = NULL, use_labels = FALSE)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{edges}{A single-length vector with a character string specifying the
edges. For a directed graph, the string object should be formatted as a
series of node ID values as \verb{[node_ID_1]->[node_ID_2]} separated by a one
or more space characters. For undirected graphs, \verb{--} should replace \verb{->}.
Line breaks in the vector won't cause an error.}

\item{rel}{An optional vector specifying the relationship between the
connected nodes.}

\item{use_labels}{An option to use node \code{label} values in the \code{edges} string
to define node connections. Note that this is only possible if all nodes
have distinct \code{label} values set and none exist as an empty string.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class \code{dgr_graph}, add one or more edges to the graph
using a text string.
}
\examples{
# Create a graph with 4 nodes
graph <-
  create_graph() \%>\%
  add_node(label = "one") \%>\%
  add_node(label = "two") \%>\%
  add_node(label = "three") \%>\%
  add_node(label = "four")

# Add edges between nodes using
# a character string with node
# ID values
graph_node_id <-
  graph \%>\%
  add_edges_w_string(
    edges = "1->2 1->3 2->4 2->3")

# Show the graph's internal
# edge data frame
graph_node_id \%>\% get_edge_df()

# Add edges between nodes using
# a character string with node
# label values and setting
# `use_labels = TRUE`; note that
# all nodes must have unique
# `label` values to use this
graph_node_label <-
  graph \%>\%
  add_edges_w_string(
    edges =
      "one->two one->three
       two->four two->three",
    use_labels = TRUE)

# Show the graph's internal
# edge data frame (it's the
# same as before)
graph_node_label \%>\% get_edge_df()
}
