## README
The `DisImpact` R package contains functions that help in determining Disproportionate Impact (DI) based on the following methodologies:

1. [Percentage Point Gap](https://www.cccco.edu/-/media/CCCCO-Website/About-Us/Divisions/Digital-Innovation-and-Infrastructure/Research/Files/PercentagePointGapMethod2017.ashx) (PPG) method,
2. [Proportionality Index](https://www.cccco.edu/-/media/CCCCO-Website/Files/DII/guidelines-for-measuring-disproportionate-impact-in-equity-plans-tfa-ada.pdf) method (method #1 in reference), and
3. [80% Index](https://www.cccco.edu/-/media/CCCCO-Website/Files/DII/guidelines-for-measuring-disproportionate-impact-in-equity-plans-tfa-ada.pdf) (method #2 in reference).

## Install Package
```R
# From CRAN
install.packages('DisImpact')

# From github (Development)
devtools::install_github('vinhdizzo/DisImpact')
```

## Vignettes and Tutorials

The `DisImpact` package offers several vignettes/tutorials to get the user familiar with the package and methods provided:

1. Package [tutorial](https://CRAN.R-project.org/package=DisImpact/vignettes/Tutorial.html).
2. [Scaling DI calculations](https://CRAN.R-project.org/package=DisImpact/vignettes/Scaling-DI-Calculations.html) across a variety of scenarios.
3. [Multi-Ethnicity Categorization](https://CRAN.R-project.org/package=DisImpact/vignettes/Multi-Ethnicity.html) and how to analyze such data with `DisImpact`.
4. [Intersectionality](https://CRAN.R-project.org/package=DisImpact/vignettes/Intersectionality.html) and how to perform such analysis with `DisImpact`.
