% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aux_fun.R
\name{fisher.pvalues.support}
\alias{fisher.pvalues.support}
\title{Computing discrete p-values and their support for Fisher's exact tests}
\usage{
fisher.pvalues.support(counts, alternative = "greater")
}
\arguments{
\item{counts}{a data frame of 3 columns and any number of lines,
each line being an item for which we want to perform a test.
The first column is the name of the item,
the second is the count of associations between the item and the condition,
the third is the count of no associations.}

\item{alternative}{same argument as in \code{\link{fisher.test}}.}
}
\value{
A list of two elements:
\item{raw}{raw discrete p-values}
\item{support}{a list of the supports of the CDFs of the p-values.
Each support is represented by a vector in increasing order.}
}
\description{
Computes discrete raw p-values and their support
for the test of no association between two categorical 
variables in 2 x 2 contingency tables using Fisher's exact tests.
}
\details{
The code for this function is inspired 
from the example in the help page
of \code{\link[discreteMTP]{p.discrete.adjust}}.

See the Wikipedia article about Fisher's
exact test, paragraph Example, for a good depiction
of what the code does for each possible value
of \code{alternative}.

This version: 2018-03-20.
}
\section{References}{

"Fisher's exact test", Wikipedia, The Free Encyclopedia,
accessed 2018-03-20,
\href{https://en.wikipedia.org/w/index.php?title=Fisher\%27s_exact_test&oldid=823327889}{link}
}

\examples{
data(amnesia)

#We only keep the first 100 lines to keep the computations fast.
amnesia<-amnesia[1:100,]

#Construction of the p-values and their support
amnesia.formatted <- fisher.pvalues.support(amnesia)
raw.pvalues <- amnesia.formatted$raw
pCDFlist <- amnesia.formatted$support
}
\seealso{
\code{\link[discreteMTP]{p.discrete.adjust}}, \code{\link{fisher.test}}
}
