% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscreteFDR-package.R
\docType{package}
\name{DiscreteFDR}
\alias{DiscreteFDR-package}
\alias{DiscreteFDR}
\title{FDR-based Multiple Testing Procedures with Adaptation for Discrete Tests}
\description{
This package implements the [HSU], [HSD],
[AHSU], [AHSD] and [HBR-\eqn{\lambda}] procedures for
discrete tests (see References).
}
\details{
The functions are reorganized from the reference paper in the following way.
\code{\link[=discrete.BH]{discrete.BH()}} (for Discrete Benjamini-Hochberg) implements
[HSU], [HSD], [AHSU] and [AHSD], while \code{\link[=DBR]{DBR()}} (for Discrete
Blanchard-Roquain) implements [HBR-\eqn{\lambda}]. \code{\link[=DBH]{DBH()}} and \code{\link[=ADBH]{ADBH()}}
are wrapper functions for \code{\link[=discrete.BH]{discrete.BH()}} to access [HSU] and [HSD], as
well as [AHSU] and [AHSD] directly.

This package is part of a package family to which the
\code{\link[DiscreteDatasets:DiscreteDatasets-package]{DiscreteDatasets}} and
\code{\link[DiscreteTests:DiscreteTests-package]{DiscreteTests}} packages also
belong. The latter allows to compute p-values and their respective supports
for various tests. The objects that contain these results can be used
directly by the \code{\link[=discrete.BH]{discrete.BH()}}, \code{\link[=DBH]{DBH()}}, \code{\link[=ADBH]{ADBH()}} and \code{\link[=DBR]{DBR()}}
functions. Alternatively, these functions also accept a vector of raw
observed p-values and a list of the respective discrete supports of the CDFs
of the p-values.

\strong{Note}: The former function \code{\link[=fisher.pvalues.support]{fisher.pvalues.support()}}, which allows to
compute such p-values and supports in the framework of a Fisher's exact test,
is now deprecated and should not be used anymore. It has been replaced by
\code{\link[=generate.pvalues]{generate.pvalues()}}.

The same applies for the function \code{\link[=fast.Discrete]{fast.Discrete()}}, which is a wrapper for
\code{\link[=fisher.pvalues.support]{fisher.pvalues.support()}} and \code{\link[=discrete.BH]{discrete.BH()}} and allows to apply
discrete procedures directly to a data set of contingency tables and perform
data pre-processing before p-values are computed. It is also now deprecated
and has been replaced by \code{\link[=direct.discrete.BH]{direct.discrete.BH()}}, but for more flexibility,
users may employ pipes, e.g.\cr
\verb{data |>}\cr
\verb{  DiscreteDatasets::reconstruct_*(<args>) |>}\cr
\verb{  DiscreteTests::*.test.pv(<args>) |>}\cr
\verb{  discrete.BH(<args>)}.
}
\references{
Döhler, S., Durand, G., & Roquain, E. (2018). New FDR bounds for discrete
and heterogeneous tests. \emph{Electronic Journal of Statistics}, \emph{12}(1),
pp. 1867-1900. \doi{10.1214/18-EJS1441}

G. Blanchard and E. Roquain (2009). Adaptive false discovery rate control
under independence and dependence. \emph{Journal of Machine Learning Research},
\emph{10}, pp. 2837-2871.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/DISOhda/DiscreteFDR}
  \item Report bugs at \url{https://github.com/DISOhda/DiscreteFDR/issues}
}

}
\author{
\strong{Maintainer}: Florian Junge \email{diso.fbmn@h-da.de} [contributor]

Authors:
\itemize{
  \item Sebastian Döhler [contributor]
  \item Guillermo Durand [contributor]
}

Other contributors:
\itemize{
  \item Etienne Roquain [contributor]
  \item Christina Kihn [contributor]
}

}
