% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGF_gamma.R
\name{MGF_gamma}
\alias{MGF_gamma}
\title{Moment Generating Function of the Gamma distribution}
\usage{
MGF_gamma(t, shape, rate = 1/scale, scale = 1/rate)
}
\arguments{
\item{t}{t.}

\item{shape}{shape parameter \eqn{\alpha}{alpha}, must be positive integer.}

\item{rate}{\eqn{\beta}{beta} is the rate parameter, must be positive.}

\item{scale}{alternative parameterization to rate parameter, scale = 1 / rate.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{MGF_gamma}}}{ gives the moment generating function (MGF).}
 \item{\code{\link{E_gamma}}}{ gives the expected value.}
 \item{\code{\link{V_gamma}}}{ gives the variance.}
 \item{\code{\link{kthmoment_gamma}}}{ gives the kth moment.}
 \item{\code{\link{Etronq_gamma}}}{ gives the truncated mean.}
 \item{\code{\link{SL_gamma}}}{ gives the stop-loss.}
 \item{\code{\link{Elim_gamma}}}{ gives the limited mean.}
 \item{\code{\link{Mexcess_gamma}}}{ gives the mean excess loss.}
 \item{\code{\link{TVaR_gamma}}}{ gives the Tail Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Moment Generating Function (MGF) of the Gamma distribution
 with shape parameter \eqn{\alpha}{alpha} and rate parameter
 \eqn{\beta}{beta}.
}
\details{
The Gamma distribution with shape parameter \eqn{\alpha}{a} and rate
   parameter \eqn{\beta}{b} has density:
  \deqn{f\left(x\right) = \frac{\beta^{\alpha}}{\Gamma(\alpha)} x^{\alpha - 1}%
   \textrm{e}^{-\beta x}}{f(x) = b^a / \Gamma(a) x^{a - 1} e^{-b x}}
  for \eqn{x \in \mathcal{R}^+}{x > 0}, \eqn{\beta, \alpha > 0}{b, a > 0}.
}
\examples{

MGF_gamma(t = 1, shape = 3, rate = 5)

}
\seealso{
Other Gamma Distribution: 
\code{\link{E_gamma}()},
\code{\link{Elim_gamma}()},
\code{\link{Etronq_gamma}()},
\code{\link{Mexcess_gamma}()},
\code{\link{SL_gamma}()},
\code{\link{TVaR_gamma}()},
\code{\link{V_gamma}()},
\code{\link{VaR_gamma}()},
\code{\link{kthmoment_gamma}()}
}
\concept{Gamma Distribution}
