% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TVaR_pois.R
\name{TVaR_pois}
\alias{TVaR_pois}
\title{Tail Value-at-Risk of the Poisson distribution}
\usage{
TVaR_pois(kap, lambda, k0)
}
\arguments{
\item{kap}{probability.}

\item{lambda}{Rate parameter \eqn{\lambda}{lambda}.}

\item{k0}{point up to which to sum the distribution to approximate the expected value.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{MGF_pois}}}{ gives the moment generating function (MGF).}
 \item{\code{\link{PGF_pois}}}{ gives the probability generating function (PGF).}
 \item{\code{\link{E_pois}}}{ gives the expected value.}
 \item{\code{\link{V_beta}}}{ gives the variance.}
 \item{\code{\link{Etronq_pois}}}{ gives the truncated mean.}
 \item{\code{\link{TVaR_pois}}}{ gives the Tail Value-at-Risk.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Tail Value-at-Risk of the Poisson distribution with rate parameter
 \eqn{\lambda}{lambda}.
}
\details{
The Poisson distribution with rate parameter \eqn{\lambda}{lam}
  has probability mass function :
  \deqn{Pr(X = k) = \frac{\lambda^k \textrm{e}^{-\lambda}}{k!}}{Pr(X = k) = (lam^k e^(-lam)) / k!}
  for \eqn{k = 0, 1, 2, \dots}{k = 0, 1, 2, ...}, and \eqn{\lambda > 0}{lam > 0}
}
\examples{

TVaR_pois(kap = 0.8, lambda = 3, k0 = 2E2)

}
\seealso{
Other Poisson Distribution: 
\code{\link{E_pois}()},
\code{\link{Etronq_pois}()},
\code{\link{MGF_pois}()},
\code{\link{PGF_pois}()},
\code{\link{V_pois}()}
}
\concept{Poisson Distribution}
