% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E_unifD.R
\name{E_unifD}
\alias{E_unifD}
\title{Expected value of the (discrete) Uniform distribution}
\usage{
E_unifD(min = 0, max = 1)
}
\arguments{
\item{min, max}{lower and upper limits of the distribution. Must be finite.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{E_unifD}}}{ gives the expected value.}
 \item{\code{\link{V_unifD}}}{ gives the variance.}
 \item{\code{\link{d_unifD}}}{ gives the density function.}
 \item{\code{\link{d_unifD}}}{ gives the cumulative density function.}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Expected value of the (discrete) Uniform distribution
 with min \eqn{a} and max \eqn{b}.
}
\details{
The (discrete) uniform distribution with min and max parameters \eqn{a}
  and \eqn{b} respectively has density:
  \deqn{\textrm{Pr}\left(X = x \right) = \frac{1}{b - a + 1}}{Pr(X = x) = 1 / (b - a + 1)}
  for \eqn{x \in \{a, a + 1, \dots, b - 1, b\}}{x = a, a + 1, ..., b - 1, b}.
}
\examples{

# With scale parameter
E_unifD(min = 2, max = 5)

}
\seealso{
Other Discrete Uniform Distribution: 
\code{\link{V_unifD}()},
\code{\link{d_unifD}()},
\code{\link{p_unifD}()}
}
\concept{Discrete Uniform Distribution}
