% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDI.r
\name{FDI}
\alias{FDI}
\title{Function FDI}
\usage{
FDI(data_sheet, bytes, ...)
}
\arguments{
\item{data_sheet}{\bold{either} a data.frame f.e imported from a data sheet containing\cr
"Name","item.number"\cr
"action.from.","action.to","kind.of.action"\cr
"name.of.action","action.number","classification","weighting"\cr
\cr
\bold{or} only "action.from.","action.to","kind.of.action"if exists actions and items\cr
\cr
actions: with  "name.of.action","action.number","classification","weighting\cr 
items:  with "Name","item.number"\cr}

\item{bytes}{a string where each enabled action is set to 1 and each disabled action is set to 0\cr
Setting a behaviour to 2 means it is count double}

\item{\dots}{\bold{Additional parameters:}
 \describe{
  \item{\bold{actions}}{(data.frame) with "name.of.action","action.number","classification","weighting"; Classification 1 if "action.from"" wins; Classification 2 if "action.to" wins}
  \item{\bold{Weigting}}{the factor which should be used to calculate the behavior (1 for "action.from"" wins -1 for "action.to" wins")\cr
Setting a behaviour to 2 means it is count double}
  \item{\bold{vcolors}}{as much colors as items, colors will returned as sorted FDI colors means color 1 = item rank 1, color 2 = item rank 2, and so on}
  \item{\bold{workbook}}{the XlConnect Workbook for the Excel file to be changed\cr
note: The workbook must be opened before}
  \item{\bold{sheet}}{the sheet name ( FDI will be added to be sure not to delete any data}
  \item{\bold{savecounts}}{if TRUE: save the counts of actions as sheet (availalbe only with workbook}
  \item{\bold{saveFDI}}{if TRUE: save the FDI as sheet (availalbe only with workbook}
 }}
}
\value{
returns a list with\cr
FDI - the Frequency Based Dominance index\cr
Colors - the colors supported by vcolors sorted by FDI of the items\cr
FDI_count_matrix - the counts from which the FDI was calulated\cr
}
\description{
A package to calculate Dominance Indices, print Soical Network Graphs and Music Notation Graphs.
}
\examples{
{ #you can eihter use:
data_sheet=data.frame   ("action.from"=c(1,4,2,3,4,3,4,3,4,3,4,3,4,3,4),
                         "action.to"=c(4,1,1,4,3,4,3,4,3,4,3,4,3,4,3),
"kind.of.action"= c(4,1,1,4,3,4,3,4,3,4,3,4,3,4,3),stringsAsFactors=FALSE)
items= data.frame ("Name"=c("item1","item2","item3","item4","item5","item6") ,
                   "item.number"=c(1:6),stringsAsFactors=FALSE)
actions=data.frame("name.of.action"= c("leading","following","approach","bite","threat to bite",
                                      "kick","threat to kick", "chase","retreat"),
                  "action.number"=c(1:9),
                  "classification"=c(1,2,1,1,1,1,1,1,2) ,
                  "weighting"=c(1,-1,1,1,1,1,1,1,-1),stringsAsFactors=FALSE)
#all  encounters  without leading and following
bytes= "001111111"  
FDI(data_sheet,items=items,actions=actions,bytes)
# or you can use a complete f.e Excel sheet
# you can save this data as basic excel sheet to work with
data(data_ADI)
bytes= "001111111"  
FDI(data_ADI,bytes)
   }
}
\references{
{
The Construction of Dominance Order: Comparing Performance of Five Methods Using an Individual-Based Model C. K. Hemelrijk, J. Wantia and L. Gygax, Behaviour Vol. 142, No. 8 (Aug., 2005), pp. 1037-1058
\url{http://www.jstor.org/stable/4536286}\cr
On using the DomWorld model to evaluate dominance ranking methods , de Vries, Han,  Behaviour, Volume 146, Number 6, 2009 , pp. 843-869(27)
\url{http://dx.doi.org/10.1163/156853909X412241}
}
}
\author{
Knut Krueger, \email{Knut.Krueger@equine-science.de}
}
