% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{make_plr_CCDDHNR2018}
\alias{make_plr_CCDDHNR2018}
\title{Generates data from a partially linear regression model used in Chernozhukov et al. (2018)}
\usage{
make_plr_CCDDHNR2018(
  n_obs = 500,
  dim_x = 20,
  alpha = 0.5,
  return_type = "DoubleMLData"
)
}
\arguments{
\item{n_obs}{(\code{integer(1)}) \cr
The number of observations to simulate.}

\item{dim_x}{(\code{integer(1)}) \cr
The number of covariates.}

\item{alpha}{(\code{numeric(1)}) \cr
The value of the causal parameter.}

\item{return_type}{(\code{character(1)}) \cr
If \code{"DoubleMLData"}, returns a \code{DoubleMLData} object. If \code{"data.frame"} returns a \code{data.frame()}. If \code{"data.table"} returns a \code{data.table()}. If \code{"matrix"} a named \code{list()} with entries \code{X}, \code{y} and \code{d} is returned. Every entry in the list is a \code{matrix()} object.  Default is \code{"DoubleMLData"}.
#' @return A data object according to the choice of \code{return_type}.}
}
\description{
Generates data from a partially linear regression model used in Chernozhukov et al. (2018) for Figure 1.
The data generating process is defined as

\eqn{d_i = m_0(x_i) + s_1 v_i,}

\eqn{y_i = \alpha d_i + g_0(x_i) + s_2 \zeta_i,}

with \eqn{v_i \sim \mathcal{N}(0,1)} and \eqn{\zeta_i \sim \mathcal{N}(0,1),}. The covariates are distributed as \eqn{x_i \sim \mathcal{N}(0, \Sigma)}, where  \eqn{\Sigma} is a matrix with entries  \eqn{\Sigma_{kj} = 0.7^{|j-k|}}. The nuisance functions are given by

\eqn{m_0(x_i) = a_0 x_{i,1} + a_1 \frac{\exp(x_{i,3})}{1+\exp(x_{i,3})},}

\eqn{g_0(x_i) = b_0 \frac{\exp(x_{i,1})}{1+\exp(x_{i,1})} + b_1 x_{i,3}.}
}
\references{
Chernozhukov, V., Chetverikov, D., Demirer, M., Duflo, E., Hansen, C., Newey, W. and Robins, J. (2018), Double/debiased machine learning for treatment and structural parameters. The Econometrics Journal, 21: C1-C68. doi:\href{https://doi.org/10.1111/ectj.12097}{10.1111/ectj.12097}.
}
