% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LogNormalESPlot2DCL.R
\name{LogNormalESPlot2DCL}
\alias{LogNormalESPlot2DCL}
\title{Plots log normal ES against confidence level}
\usage{
LogNormalESPlot2DCL(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 4
 or 5. In case there 4 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 investment Size of investment

 cl ES confidence level and must be a vector

 hp ES holding period and must be a scalar}
}
\description{
Plots the ES of a portfolio against confidence level assuming that geometric
returns are normally distributed, for specified confidence level and holding
period.
}
\examples{
# Plots ES against confidence level
   data <- runif(5, min = 0, max = .2)
   LogNormalESPlot2DCL(returns = data, investment = 5,
                       cl = seq(.9,.99,.01), hp = 60)

   # Plots ES against confidence level
   LogNormalESPlot2DCL(mu = .012, sigma = .03, investment = 5,
                       cl = seq(.9,.99,.01), hp = 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

