% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dailyDose.R
\name{dailyDoseCoverage}
\alias{dailyDoseCoverage}
\title{Check coverage of daily dose computation in a sample of the cdm for selected
concept sets and ingredient}
\usage{
dailyDoseCoverage(
  cdm,
  ingredientConceptId,
  sample = NULL,
  conceptSetList = NULL,
  stratifyByConcept = TRUE,
  seed = 1
)
}
\arguments{
\item{cdm}{A cdm reference created using CDMConnector}

\item{ingredientConceptId}{Code indicating the ingredient of interest}

\item{sample}{A number indicating the size of the random sample to take from
the 'person' table of the cdm}

\item{conceptSetList}{A concept list that we want to test}

\item{stratifyByConcept}{Whether to stratify the result by drug_concept_id}

\item{seed}{Seed for the random sample}
}
\value{
The function returns information of the coverage of computeDailyDose.R
for the selected ingredients and concept sets
}
\description{
Check coverage of daily dose computation in a sample of the cdm for selected
concept sets and ingredient
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()
dailyDoseCoverage(cdm, 1125315)
}

}
