% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseTreatment.R
\name{summariseTreatmentFromCohort}
\alias{summariseTreatmentFromCohort}
\title{This function is used to summarise the dose table over multiple cohorts.}
\usage{
summariseTreatmentFromCohort(
  cohort,
  strata = list(),
  window,
  treatmentCohortName,
  treatmentCohortId = NULL,
  combination = FALSE,
  minCellCount = 5
)
}
\arguments{
\item{cohort}{Cohort with drug use variables and strata.}

\item{strata}{Stratification list.}

\item{window}{Window where to summarise the treatments.}

\item{treatmentCohortName}{Name of a cohort in the cdm that contains the
interest treatments.}

\item{treatmentCohortId}{Cohort definition id of interest from
treatmentCohortName.}

\item{combination}{Whether to include combination treatments.}

\item{minCellCount}{Below this number counts will be suppressed.}
}
\value{
A summary of the drug use stratified by cohort_name and strata_name
}
\description{
This function is used to summarise the dose table over multiple cohorts.
}
\examples{
\donttest{
library(DrugUtilisation)
library(PatientProfiles)
library(CodelistGenerator)

cdm <- mockDrugUtilisation()
cdm <- generateDrugUtilisationCohortSet(
  cdm, "dus_cohort", getDrugIngredientCodes(cdm, "acetaminophen")
)
cdm[["dus_cohort"]] <- cdm[["dus_cohort"]] \%>\%
  addDrugUse(ingredientConceptId = 1125315)
result <- summariseDrugUse(cdm[["dus_cohort"]])
print(result)

cdm[["dus_cohort"]] <- cdm[["dus_cohort"]] \%>\%
  addSex() \%>\%
  addAge(ageGroup = list("<40" = c(0, 30), ">40" = c(40, 150)))

summariseDrugUse(
  cdm[["dus_cohort"]], strata = list(
   "age_group" = "age_group", "sex" = "sex",
   "age_group and sex" = c("age_group", "sex")
  )
)
}

}
