% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDrugUtilisation.R
\name{addCumulativeDose}
\alias{addCumulativeDose}
\title{To add a new column with the cumulative dose. To add multiple columns use
\code{addDrugUtilisation()} for efficiency.}
\usage{
addCumulativeDose(
  cohort,
  ingredientConceptId,
  conceptSet = NULL,
  indexDate = "cohort_start_date",
  censorDate = "cohort_end_date",
  restrictIncident = TRUE,
  nameStyle = "cumulative_dose_{concept_name}_{ingredient}",
  name = NULL
)
}
\arguments{
\item{cohort}{Cohort in the cdm.}

\item{ingredientConceptId}{Ingredient OMOP concept that we are interested for
the study. It is a compulsory input, no default value is provided.}

\item{conceptSet}{List of concepts to be included. If NULL all the
descendants of ingredient concept id will be used.}

\item{indexDate}{Name of a column that indicates the date to start the
analysis.}

\item{censorDate}{Name of a column that indicates the date to stop the
analysis, if NULL end of individuals observation is used.}

\item{restrictIncident}{Whether to include only incident prescriptions in the
analysis. If FALSE all prescriptions that overlap with the study period will
be included.}

\item{nameStyle}{Character string to specify the nameStyle of the new columns.}

\item{name}{Name of the new computed cohort table, if NULL a temporary tables is
created.}
}
\value{
The same cohort with the added column.
}
\description{
To add a new column with the cumulative dose. To add multiple columns use
\code{addDrugUtilisation()} for efficiency.
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

cdm$cohort1 |>
  addCumulativeDose(ingredientConceptId = 1125315)
}

}
