% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotTreatment}
\alias{plotTreatment}
\title{Generate a custom ggplot2 from a summarised_result object generated with
summariseTreatment function.}
\usage{
plotTreatment(
  result,
  facetX = "window_name",
  facetY = c("cdm_name", "cohort_name", "strata"),
  splitStrata = TRUE,
  colour = "treatment"
)
}
\arguments{
\item{result}{A summarised_result object with results from
summariseDrugRestart().}

\item{facetX}{Vector of variables to facet by horizontally. Allowed options
are: "cdm_name", "cohort_name", "strata", "variable_name"}

\item{facetY}{Vector of variables to facet by vertically Allowed options
are: "cdm_name", "cohort_name", "strata", "variable_name".}

\item{splitStrata}{Whether to split strata columns.}

\item{colour}{Vector of variables to distinct by colour. Allowed options
are: "cdm_name", "cohort_name", "strata", "variable_name", and
"variable_level".}
}
\value{
A ggplot2 object.
}
\description{
Generate a custom ggplot2 from a summarised_result object generated with
summariseTreatment function.
}
\examples{
\dontrun{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()
result <- cdm$cohort1 |>
  summariseTreatment(
    treatmentCohortName = "cohort2",
    window = list(c(0, 30), c(31, 365))
  )

plotTreatment(result)
}

}
