% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tableTreatment}
\alias{tableTreatment}
\title{Format a summarised_treatment result into a visual table.}
\usage{
tableTreatment(
  result,
  header = c("window_name"),
  splitStrata = TRUE,
  cdmName = TRUE,
  groupColumn = c("cdm_name", "cohort_name"),
  type = "gt",
  formatEstimateName = c(`N (\%)` = "<count> (<percentage> \%)"),
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result object with results from
summariseTreatmentFromCohort() or summariseTreatmentFromConceptSet().}

\item{header}{A vector containing which elements should go into the header
in order. Allowed values: \code{cdm_name}, \code{cohort_name}, \code{strata}, \code{variable},
\code{estimate} and \code{window_name}.}

\item{splitStrata}{If TRUE strata columns will be split.}

\item{cdmName}{If TRUE database names will be displayed.}

\item{groupColumn}{Column to use as group labels. Allowed values: \code{cdm_name},
\code{cohort_name}, \code{strata}, \code{variable}, \code{estimate} and \code{window_name}.}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{formatEstimateName}{Named list of estimate name's to join, sorted by
computation order. Indicate estimate_name's between <...>.}

\item{.options}{Named list with additional formatting options.
DrugUtilisation::defaultTableOptions() shows allowed arguments and their
default values.}
}
\value{
A table with a formatted version of summariseTreatment() results.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()
result <- cdm$cohort1 |>
  summariseTreatment(
    treatmentCohortName = "cohort2",
    window = list(c(0, 30), c(31, 365))
  )

tableTreatment(result)
}

}
