% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/online.r
\name{websearch_comptox}
\alias{websearch_comptox}
\title{Search and retrieve substance information from \url{https://comptox.epa.gov/dashboard}}
\usage{
websearch_comptox(
  searchItems,
  identifierTypes = c("chemical_name", "CASRN", "INCHIKEY", "dtxsid"),
  inputType = c("IDENTIFIER", "DTXCID", "INCHIKEY_SKELETON", "MSREADY_FORMULA",
    "EXACT_FORMULA", "MASS"),
  downloadItems = c("DTXCID", "CASRN", "INCHIKEY", "IUPAC_NAME", "SMILES",
    "INCHI_STRING", "MS_READY_SMILES", "QSAR_READY_SMILES", "MOLECULAR_FORMULA",
    "AVERAGE_MASS", "MONOISOTOPIC_MASS", "QC_LEVEL", "SAFETY_DATA", "EXPOCAST",
    "DATA_SOURCES", "TOXVAL_DATA", "NUMBER_OF_PUBMED_ARTICLES", "PUBCHEM_DATA_SOURCES",
    "CPDAT_COUNT", "IRIS_LINK", "PPRTV_LINK", "WIKIPEDIA_ARTICLE", "QC_NOTES",
    "ABSTRACT_SHIFTER", "TOXPRINT_FINGERPRINT", "ACTOR_REPORT", "SYNONYM_IDENTIFIER",
    "RELATED_RELATIONSHIP", "ASSOCIATED_TOXCAST_ASSAYS", 
     "TOXVAL_DETAILS",
    "CHEMICAL_PROPERTIES_DETAILS", "BIOCONCENTRATION_FACTOR_TEST_PRED",
    "BOILING_POINT_DEGC_TEST_PRED", "48HR_DAPHNIA_LC50_MOL/L_TEST_PRED",
    "DENSITY_G/CM^3_TEST_PRED", "DEVTOX_TEST_PRED",
    "96HR_FATHEAD_MINNOW_MOL/L_TEST_PRED", "FLASH_POINT_DEGC_TEST_PRED",
    "MELTING_POINT_DEGC_TEST_PRED", "AMES_MUTAGENICITY_TEST_PRED",
    "ORAL_RAT_LD50_MOL/KG_TEST_PRED", "SURFACE_TENSION_DYN/CM_TEST_PRED",
    "THERMAL_CONDUCTIVITY_MW/(M*K)_TEST_PRED",
    "TETRAHYMENA_PYRIFORMIS_IGC50_MOL/L_TEST_PRED", "VISCOSITY_CP_CP_TEST_PRED", 
    
    "VAPOR_PRESSURE_MMHG_TEST_PRED", "WATER_SOLUBILITY_MOL/L_TEST_PRED",
    "ATMOSPHERIC_HYDROXYLATION_RATE_(AOH)_CM3/MOLECULE*SEC_OPERA_PRED",
    "BIOCONCENTRATION_FACTOR_OPERA_PRED",
    "BIODEGRADATION_HALF_LIFE_DAYS_DAYS_OPERA_PRED", "BOILING_POINT_DEGC_OPERA_PRED",
    "HENRYS_LAW_ATM-M3/MOLE_OPERA_PRED", "OPERA_KM_DAYS_OPERA_PRED",
    "OCTANOL_AIR_PARTITION_COEFF_LOGKOA_OPERA_PRED",
    "SOIL_ADSORPTION_COEFFICIENT_KOC_L/KG_OPERA_PRED",
    "OCTANOL_WATER_PARTITION_LOGP_OPERA_PRED", "MELTING_POINT_DEGC_OPERA_PRED", 
    
    "OPERA_PKAA_OPERA_PRED", "OPERA_PKAB_OPERA_PRED", "VAPOR_PRESSURE_MMHG_OPERA_PRED",
    "WATER_SOLUBILITY_MOL/L_OPERA_PRED",
    "EXPOCAST_MEDIAN_EXPOSURE_PREDICTION_MG/KG-BW/DAY", "NHANES",
    "TOXCAST_NUMBER_OF_ASSAYS/TOTAL", "TOXCAST_PERCENT_ACTIVE"),
  massError = 0,
  timeout = 300,
  verify_ssl = getOption("ECOTOXr_verify_ssl"),
  ...
)
}
\arguments{
\item{searchItems}{A \code{vector} of \code{character}s where each element is a substance descriptor (any of the selected \code{identifierType}s) you
wish to query.}

\item{identifierTypes}{Substance identifiers for searching CompTox. Only used when \code{inputType} is set to \code{"IDENTIFIER"}.}

\item{inputType}{Type of input used for searching CompTox. See usage section for valid entries.}

\item{downloadItems}{Output fields of CompTox data for requested substances}

\item{massError}{Error tolerance when searching for substances based on their monoisotopic mass. Only used for \code{inputType = "MASS"}.}

\item{timeout}{Time in seconds (default is 300 secs), that the routine will wait for the download link to get ready.
It will throw an error if it takes longer than the specified \code{timeout}.}

\item{verify_ssl}{When set to \code{FALSE} the SSL certificate of the host (EPA)
is not verified. Can also be set as option:
\code{options(ECOTOXr_verify_ssl = TRUE)}. Default is \code{TRUE}.}

\item{...}{Arguments passed on to \code{\link[httr2:req_options]{httr2::req_options()}} requests.}
}
\value{
Returns a named \code{list} of \link[dplyr:reexports]{dplyr::tibble}s containing the search results for the requested output tables and fields.
Results are unpolished and `as is' returned by EPA's web service.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Search \url{https://comptox.epa.gov/dashboard} for substances and their chemico-physical properties
and meta-information.
}
\details{
The \href{https://comptox.epa.gov/dashboard}{CompTox Chemicals Dashboard} is a freely accessible on-line U.S. EPA database.
It contains information on physico-chemical properties, environmental fate and transport, exposure, usage, \emph{in vivo} toxicity,
and \emph{in vitro} bioassay of a wide range of substances.

The function described here to search and retrieve records from the on-line database is experimental. This is because this feature is
not formally supported by the EPA, and it may break in future incarnations of the on-line database. The function forms an interface between
R and the \href{https://comptox.epa.gov/dashboard}{CompTox} website and is therefore limited by the restrictions documented there.
}
\examples{
\dontrun{
## search for substance name 'benzene' and CAS registration number 108-88-3
## on https://comptox.epa.gov/dashboard:
comptox_results <- websearch_comptox(c("benzene", "108-88-3"))

## search for substances with monoisotopic mass of 100+/-5:
comptox_results2 <- websearch_comptox("100", inputType = "MASS", massError = 5)
}
}
\references{
Official US EPA CompTox website:
\url{https://comptox.epa.gov/dashboard/}

Williams, A.J., Grulke, C.M., Edwards, J., McEachran, A.D., Mansouri, K, Baker, N.C., Patlewicz, G., Shah, I.,
Wambaugh, J.F., Judson, R.S. & Richard, A.M. (2017), The CompTox Chemistry Dashboard: a community data resource
for environmental chemistry. \emph{J Cheminform}, 9(61) \doi{10.1186/s13321-017-0247-6}
}
\seealso{
Other search-functions: 
\code{\link{search_ecotox}()},
\code{\link{websearch_ecotox}()}
}
\author{
Pepijn de Vries
}
\concept{onlinesearch-functions}
\concept{search-functions}
