% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_path.R
\name{sample_path}
\alias{sample_path}
\title{Sample path from the distribution of an endpoint-conditioned CTMC.}
\usage{
sample_path(a, b, t0, t1, Q, method = "mr", npaths = 1, eigen_vals = NULL,
  eigen_vecs = NULL, inverse_vecs = NULL, P = NULL)
}
\arguments{
\item{a, b}{States at the left and right endpoints of the interval, given as
row numbers of the CTMC rate matrix}

\item{t0, t1}{Times for the left and right endpoints of the interval.}

\item{Q}{CTMC rate matrix.}

\item{method}{Either "mr" corresponding to modified rejection sampling, or
"unif" for uniformization.}

\item{npaths}{optional argument for the number of sample paths to simulate.}

\item{eigen_vals}{optional vector of eigen values of Q (assumes all eigen
values are real).}

\item{eigen_vecs}{optional matrix of eigen vectors of Q.}

\item{inverse_vecs}{optional inverse of the eigen vector matrix.}

\item{P}{optional transition probability matrix over the interval}
}
\value{
sample_path returns either a matrix with a sample path or a list of
  matrices of sample paths.
}
\description{
Sample path from the distribution of an endpoint-conditioned CTMC.
}
\examples{
sample_path(1, 2, 0, 5, matrix(c(-0.49, 0.49, 0.51, -0.51), nrow = 2, byrow = TRUE))

}

