% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sample_path_unif2}
\alias{sample_path_unif2}
\title{Simulate a sample path from an endpoint conditioned CTMC by uniformization
using pre-computed eigen-values (assumes that all eigenvalues are real).}
\usage{
sample_path_unif2(a, b, t0, t1, Q, eigen_vals, eigen_vecs, inverse_vecs)
}
\arguments{
\item{a, b}{States at the interval endpoints, provided as integers
corresponding to rows of the CTMC rate matrix.}

\item{t0, t1}{times of the interval endpoints}

\item{Q}{CTMC rate matrix}

\item{eigen_vals}{vector of eigen values of Q.}

\item{eigen_vecs}{matrix of eigen vectors of Q.}

\item{inverse_vecs}{inverse of the eigen vector matrix.}
}
\value{
matrix whose first column is the sequence of transition times
bookended by interval endpoints, and whose second column is the sequence of
states
}
\description{
Simulate a sample path from an endpoint conditioned CTMC by uniformization
using pre-computed eigen-values (assumes that all eigenvalues are real).
}

