% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality.R
\name{dimensionality}
\alias{dimensionality}
\alias{dimensionality.default}
\alias{dimensionality.formula}
\title{Measures of dimensionality}
\usage{
dimensionality(...)

\method{dimensionality}{default}(x, y, measures = "all", ...)

\method{dimensionality}{formula}(formula, data, measures = "all", ...)
}
\arguments{
\item{...}{Not used.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A response vector with one value for each row/component of x.}

\item{measures}{A list of measures names or \code{"all"} to include all them.}

\item{formula}{A formula to define the output column.}

\item{data}{A data.frame dataset contained the input and output attributes.}
}
\value{
A list named by the requested dimensionality measure.
}
\description{
These measures give an indicative of data sparsity. They capture how sparse 
a datasets tend to have regions of low density. These regions are know to be 
more difficult to extract good classification and regression models.
}
\details{
The following measures are allowed for this method:
 \describe{
   \item{"T2"}{Average number of points per dimension (T2) is given by the 
     ratio between the number of examples and dimensionality of the dataset.}
   \item{"T3"}{Average number of points per PCA (T3) is similar to T2, but 
     uses the number of PCA components needed to represent 95% of data 
     variability as the base of data sparsity assessment.}
   \item{"T4"}{Ratio of the PCA Dimension to the Original (T4) estimates the
     proportion of relevant and the original dimensions for a dataset.}
 }
}
\examples{
## Extract all dimensionality measures
data(iris)
dimensionality(Species ~ ., iris)

data(cars)
correlation(speed~., cars)
}
\references{
Ana C Lorena, Ivan G Costa, Newton Spolaor and Marcilio C P Souto. (2012). 
   Analysis of complexity indices for classification problems: Cancer gene 
   expression data. Neurocomputing 75, 1, 33--42.
}
\seealso{
Other complexity-measures: \code{\link{balance}},
  \code{\link{correlation}}, \code{\link{linearity.class}},
  \code{\link{linearity.regr}}, \code{\link{neighborhood}},
  \code{\link{network}}, \code{\link{overlapping}},
  \code{\link{smoothness}}
}
\concept{complexity-measures}
