% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lastnews_table.R
\name{lastnews_table}
\alias{lastnews_table}
\title{Get a table with the latest date for each patient}
\usage{
lastnews_table(
  except = NULL,
  with_ties = FALSE,
  show_delta = FALSE,
  numeric_id = TRUE,
  prefer = NULL,
  regex = FALSE,
  warn_if_future = TRUE
)
}
\arguments{
\item{except}{the datasets/columns that should not be searched. Example: a scheduled visit for which the patient may have died before attending should not be considered.}

\item{with_ties}{in case of tie, whether to return the first \code{origin} (FALSE) or all the origins that share this tie (TRUE).}

\item{show_delta}{whether to compute the difference between the last \code{prefer} date and the actual last date}

\item{numeric_id}{set to FALSE if the patient ID column is not numeric}

\item{prefer}{preferred origins in the event of a tie. Usually the followup table.}

\item{regex}{whether to consider \code{except} and \code{prefer} as regex.}

\item{warn_if_future}{whether to show a warning about dates that are after the extraction date. Can also be a csv file path to save the warning as csv (see \code{csv_path} argument in \link{edc_data_warn}).}
}
\value{
a dataframe
}
\description{
This function search for date columns in every tables and returns the latest date
for each patient with the variable it comes from. Useful in survival analysis to get
the right censoring time.
}
\examples{
db = edc_example()
load_database(db)
lastnews_table()
lastnews_table(except="data3")
lastnews_table(except="data3$date9")
lastnews_table(prefer="date10", show_delta=TRUE) 
lastnews_table() \%>\% 
  dplyr::count(origin = glue::glue("{origin_data}${origin_col}"), 
  sort=TRUE)

csv_file = tempfile(fileext=".csv")
lastnews_table(prefer="date9", warn_if_future=csv_file) 
}
