% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_recent_uploads.R
\name{list_recent_uploads}
\alias{list_recent_uploads}
\title{List recent uploads}
\usage{
list_recent_uploads(type, limit = 5, as = "data.frame", env = "production")
}
\arguments{
\item{type}{(character) Upload type. Can be: "insert" or "update".}

\item{limit}{(numeric) Maximum number of results to return}

\item{as}{(character) Format of the returned object. Can be: "data.frame" 
or "xml".}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame or xml_document) Data package uploads
}
\description{
List recent uploads
}
\examples{
\dontrun{

# Get the 3 newest revisions
dataPackageUploads <- list_recent_uploads("update", 3)
}
}
\seealso{
Other Listing: 
\code{\link{list_data_descendants}()},
\code{\link{list_data_entities}()},
\code{\link{list_data_package_identifiers}()},
\code{\link{list_data_package_revisions}()},
\code{\link{list_data_package_scopes}()},
\code{\link{list_data_sources}()},
\code{\link{list_deleted_data_packages}()},
\code{\link{list_recent_changes}()},
\code{\link{list_service_methods}()},
\code{\link{list_user_data_packages}()}
}
\concept{Listing}
