% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.OMEGA.R
\name{print.OMEGA}
\alias{print.OMEGA}
\title{Print OMEGA object}
\usage{
\method{print}{OMEGA}(x, digits = 3, ...)
}
\arguments{
\item{x}{output of class OMEGA (output from the \link{OMEGA} function)}

\item{digits}{numeric. Passed to \code{\link[base:Round]{round}}. Number of digits
to round to (default is 3).}

\item{...}{additional arguments passed to print}
}
\description{
Print OMEGA object
}
\examples{
efa_mod <- EFA(test_models$baseline$cormat, N = 500, n_factors = 3,
               type = "EFAtools", method = "PAF", rotation = "promax")
sl_mod <- SL(efa_mod, type = "EFAtools", method = "PAF")

OMEGA(sl_mod, type = "EFAtools", factor_corres = rep(c(3, 2, 1), each = 6))

}
