% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EBICglasso.qgraph.R
\name{EBICglasso.qgraph}
\alias{EBICglasso.qgraph}
\title{\code{\link[qgraph]{EBICglasso}} from \code{\link{qgraph}} 1.4.4}
\usage{
EBICglasso.qgraph(
  data,
  n = NULL,
  gamma = 0.5,
  penalize.diagonal = FALSE,
  nlambda = 100,
  lambda.min.ratio = 0.1,
  returnAllResults = FALSE,
  penalizeMatrix,
  countDiagonal = FALSE,
  refit = FALSE,
  ...
)
}
\arguments{
\item{data}{Data matrix}

\item{n}{Number of participants}

\item{gamma}{EBIC tuning parameter. 0.5 is generally a good choice.
Setting to zero will cause regular BIC to be used.}

\item{penalize.diagonal}{Should the diagonal be penalized?}

\item{nlambda}{Number of lambda values to test.}

\item{lambda.min.ratio}{Ratio of lowest lambda value compared to maximal lambda.
Defaults to \code{0.1}.
\strong{NOTE} \code{\link{qgraph}} sets the default to \code{0.01}}

\item{returnAllResults}{If \code{TRUE} this function does not
return a network but the results of the entire glasso path.}

\item{penalizeMatrix}{Optional logical matrix to indicate which elements are penalized}

\item{countDiagonal}{Should diagonal be counted in EBIC computation?
Defaults to \code{FALSE}. Set to \code{TRUE} to mimic qgraph < 1.3 behavior (not recommended!).}

\item{refit}{Logical, should the optimal graph be refitted without LASSO regularization?
Defaults to \code{FALSE}.}

\item{...}{Arguments sent to \code{\link[glasso]{glasso}}}
}
\value{
A partial correlation matrix
}
\description{
This function uses the \code{\link[glasso]{glasso}} package
(Friedman, Hastie and Tibshirani, 2011) to compute a
sparse gaussian graphical model with the graphical lasso
(Friedman, Hastie & Tibshirani, 2008).
The tuning parameter is chosen using the Extended Bayesian Information criterium
(EBIC) described by Foygel & Drton (2010).
}
\details{
The glasso is run for 100 values of the tuning parameter logarithmically
spaced between the maximal value of the tuning parameter at which all edges are zero,
lambda_max, and lambda_max/100. For each of these graphs the EBIC is computed and
the graph with the best EBIC is selected. The partial correlation matrix
is computed using \code{\link[qgraph]{wi2net}} and returned.
}
\examples{
# Obtain data
wmt <- wmt2[,7:24]

\dontrun{
# Compute graph with tuning = 0 (BIC)
BICgraph <- EBICglasso.qgraph(
  data = wmt, gamma = 0
)

# Compute graph with tuning = 0.5 (EBIC)
EBICgraph <- EBICglasso.qgraph(
  data = wmt, gamma = 0.5
)}

}
\references{
# Instantiation of GLASSO \cr
Friedman, J., Hastie, T., & Tibshirani, R. (2008).
Sparse inverse covariance estimation with the graphical lasso.
\emph{Biostatistics}, \emph{9}, 432-441.

# Tutorial on EBICglasso
Epskamp, S., & Fried, E. I. (2018).
A tutorial on regularized partial correlation networks.
\emph{Psychological Methods}, \emph{23}(4), 617–634.

# glasso package \cr
Friedman, J., Hastie, T., & Tibshirani, R. (2011).
glasso: Graphical lasso-estimation of Gaussian graphical models.
R package version 1.7.

# glasso + EBIC \cr
Foygel, R., & Drton, M. (2010).
Extended Bayesian information criteria for Gaussian graphical models.
\emph{In Advances in neural information processing systems} (pp. 604-612).
}
\author{
Sacha Epskamp <mail@sachaepskamp.com>
}
