% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mergeReport}
\alias{mergeReport}
\title{Merge Sample and Daily Data for WRTDS}
\usage{
mergeReport(INFO, Daily, Sample, surfaces = NA, interactive = TRUE)
}
\arguments{
\item{INFO}{dataframe containing the INFO dataframe}

\item{Daily}{dataframe containing the daily data}

\item{Sample}{dataframe containing the sample data}

\item{surfaces}{matrix returned from \code{modelEstimation}. Default is NA.}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
eList named list with Daily, Sample, and INFO dataframes, along with the surfaces matrix.
Any of these values can be NA, not all EGRET functions will work with missing parts of the named list eList.
}
\description{
Merges the flow data from the daily record into the sample record.
}
\examples{
\dontrun{
siteNumber <- '01594440'
pCode <- '01075'
Daily <- readNWISDaily(siteNumber,'00060', '1985-01-01', '1990-03-31')
Sample <- readNWISSample(siteNumber,pCode, '1985-01-01', '1990-03-31')
INFO <- readNWISInfo(siteNumber,pCode,interactive=FALSE)
eList <- mergeReport(INFO, Daily, Sample)
eList
}
}
\seealso{
\code{\link{readNWISDaily}}, \code{\link{readNWISSample}}
}
\keyword{USGS}
\keyword{WRTDS}
\keyword{data}
\keyword{import}

