% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_fit_choice}
\alias{plot_fit_choice}
\title{Plots choice data}
\usage{
plot_fit_choice(
  data,
  pp,
  subject = NULL,
  factors = NULL,
  functions = NULL,
  stat = NULL,
  stat_name = "",
  adjust = 1,
  ci = c(0.025, 0.5, 0.975),
  do_plot = TRUE,
  xlim = NULL,
  ylim = NULL,
  main = "",
  layout = NULL,
  mfcol = TRUE,
  signalFactor = "S",
  zROC = FALSE,
  qfun = qnorm,
  lim = NULL,
  rocfit_cex = 0.5
)
}
\arguments{
\item{data}{A data frame. The experimental data in EMC2 format with at least \code{subject} (i.e., the
subject factor), \code{R} (i.e., the response factor) and \code{rt} (i.e., response time) variable.
Additional factor variables of the design are optional.}

\item{pp}{Posterior predictives created by \code{predict()}}

\item{subject}{Integer or string picking out subject(s).}

\item{factors}{Character vector of factors in data to display separately. If
\code{NULL} (i.e., the default), use names of all columns in data except \code{trials},\code{R}, and \code{rt}.
Omitted factors are aggregated over. If \code{NA}, treats entire data set as a single cell.
If \code{stat} is used, the default is changed to \code{NA}.}

\item{functions}{A named list of functions that create new factors which can then be
used by the \code{factors} and \code{stat} arguments.}

\item{stat}{A function that takes a the data and returns a single value.}

\item{stat_name}{A string naming what the \code{stat} argument calculates.}

\item{adjust}{Control of smoothing in density plots}

\item{ci}{Credible interval and central tendency quantiles for return when
stat argument is supplied (defaults to the 2.5\\\%, the 50\\\% and the 97.5\\\%
quantiles)}

\item{do_plot}{Boolean (defaults to \code{TRUE}) whether a plot should be created or not}

\item{xlim}{x-axis plot limit, 2-vector (same for all) or matrix (one row for each paramter)}

\item{ylim}{y-axis plot limit, 2-vector (same for all) or matrix (one row for each paramter)}

\item{main}{Text title, pasted before cell name.}

\item{layout}{2-vector specifying \code{par(mfrow)} or \code{par(mfcol)}. The default \code{NULL} uses current,
\code{NA} keeps \code{par} currently active.}

\item{mfcol}{Boolean for \code{layout} settings, the default \code{TRUE} uses \code{mfcol}, else \code{mfrow}.}

\item{signalFactor}{Character name of factor for the signal}

\item{zROC}{Boolean, plot Z transformed ROC (defaults to \code{FALSE})}

\item{qfun}{Type of Z transform (defaults to probit)}

\item{lim}{\code{x} = \code{y} limit for ROC plots}

\item{rocfit_cex}{Size of points in ROC plot (default 0.5)}
}
\value{
If stat argument is provided a matrix of observed values and predicted quantiles
is returned
}
\description{
Plots choice data with no response times.
}
