% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{get_pars}
\alias{get_pars}
\title{Filter/manipulate parameters from emc object}
\usage{
get_pars(
  emc,
  selection = "mu",
  stage = "sample",
  thin = 1,
  filter = 0,
  map = FALSE,
  add_recalculated = FALSE,
  length.out = NULL,
  by_subject = FALSE,
  return_mcmc = TRUE,
  merge_chains = FALSE,
  subject = NULL,
  flatten = FALSE,
  remove_dup = FALSE,
  remove_constants = TRUE,
  use_par = NULL,
  type = NULL,
  true_pars = NULL,
  chain = NULL,
  covariates = NULL
)
}
\arguments{
\item{emc}{an emc object.}

\item{selection}{A Character string. Indicates which parameter type to select (e.g., \code{alpha}, \code{mu}, \code{sigma2}, \code{correlation}).}

\item{stage}{A character string. Indicates from which sampling stage(s) to take the samples from (i.e. \code{preburn}, \code{burn}, \code{adapt}, \code{sample})}

\item{thin}{An integer. By how much to thin the chains}

\item{filter}{Integer or numeric vector. If an integer is supplied, iterations
up until that integer are removed. If a vector is supplied, the iterations
within the range are kept.}

\item{map}{Boolean. If \code{TRUE} parameters will be mapped back to the cells of
the experimental design using the design matrices.
Otherwise the sampled parameters are returned.
Only works for \code{selection = mu} or \code{selection = alpha}.}

\item{add_recalculated}{Boolean. If \code{TRUE} will also add recalculated parameters,
such as b in the LBA (b = B + A; see \code{?LBA}), or z in the DDM z = Z*A (see \code{?DDM})
only works when \code{map = TRUE}}

\item{length.out}{Integer. Alternatively to thinning, you can also select a
desired length of the MCMC chains, which will be thinned appropriately.}

\item{by_subject}{Boolean. If \code{TRUE} for selections that include subject parameters (e.g. \code{alpha}),
plot/stats are organized by subject, otherwise by parameter.}

\item{return_mcmc}{Boolean. If \code{TRUE} returns an mcmc.list object, otherwise a matrix/array with the parameter type.}

\item{merge_chains}{Boolean. If \code{TRUE} returns parameter type merged across chains.}

\item{subject}{Integer (vector) or character (vector). If an integer will select the 'x'th subject(s),
if a character it should match subject names in the data which will be selected.}

\item{flatten}{Boolean. If \code{FALSE} for 3-dimensional samples (e.g., correlations: n-pars x n-pars x iterations).
organizes by the dimension containing parameter names, otherwise collapses names across the first and second dimension.
Does not apply for \code{selection = "alpha"}}

\item{remove_dup}{Boolean. If \code{TRUE} removes duplicate values from the samples. Automatically set to \code{TRUE} if \code{flatten = TRUE}}

\item{remove_constants}{Boolean. If \code{TRUE} removes constant values from the samples (e.g. 0s in the covariance matrix).}

\item{use_par}{Character (vector). If specified, only these parameters are returned. Should match the parameter names
(i.e. these are collapsed when \code{flatten = TRUE} and use_par should also be collapsed names).}

\item{type}{Character indicating the group-level model selected. Only necessary if sampler isn't specified.}

\item{true_pars}{Set of \code{true_parameters} can be specified to apply flatten or use_par on a set of true parameters}

\item{chain}{Integer. Which of the chain(s) to return}

\item{covariates}{Only needed with \code{plot_prior} and covariates in the design}
}
\value{
An mcmc.list object of the selected parameter types with the specified manipulations
}
\description{
Underlying function used in most plotting and object handling functions in
EMC2. Can for example be used to filter/thin a parameter type
(i.e, group-level means \code{mu}) and convert to an mcmc.list.
}
\examples{
# E.g. get the group-level mean parameters mapped back to the design
get_pars(samples_LNR, stage = "sample", map = TRUE, selection = "mu")

# Or return the flattened correlation, with 10 iterations per chain
get_pars(samples_LNR, stage = "sample", selection = "correlation", flatten = TRUE, length.out = 10)
}
