% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_data.R
\name{plot_cdf}
\alias{plot_cdf}
\title{Plot Defective Cumulative Distribution Functions}
\usage{
plot_cdf(
  input,
  post_predict = NULL,
  prior_predict = NULL,
  subject = NULL,
  quants = c(0.025, 0.975),
  functions = NULL,
  factors = NULL,
  defective_factor = "R",
  n_cores = 1,
  n_post = 50,
  layout = NA,
  to_plot = c("data", "posterior", "prior")[1:2],
  use_lim = c("data", "posterior", "prior")[1:2],
  legendpos = c("top", "topright"),
  posterior_args = list(),
  prior_args = list(),
  ...
)
}
\arguments{
\item{input}{Either an \code{emc} object or a data frame, or a \emph{list} of such objects.}

\item{post_predict}{Optional posterior predictive data (matching columns) or \emph{list} thereof.}

\item{prior_predict}{Optional prior predictive data (matching columns) or \emph{list} thereof.}

\item{subject}{Subset the data to a single subject (by index or name).}

\item{quants}{Numeric vector of credible interval bounds (e.g. \code{c(0.025, 0.975)}).}

\item{functions}{A function (or list of functions) that create new columns in the datasets or predictives}

\item{factors}{Character vector of factor names to aggregate over;
defaults to plotting full data set ungrouped by factors if \code{NULL}.}

\item{defective_factor}{Name of the factor used for the defective CDF (default "R").}

\item{n_cores}{Number of CPU cores to use if generating predictives from an \code{emc} object.}

\item{n_post}{Number of posterior draws to simulate if needed for predictives.}

\item{layout}{Numeric vector used in \code{par(mfrow=...)}; use \code{NA} for auto-layout.}

\item{to_plot}{Character vector: any of \code{"data"}, \code{"posterior"}, \code{"prior"}.}

\item{use_lim}{Character vector controlling which source(s) define \code{xlim}.}

\item{legendpos}{Character vector controlling the positions of the legends}

\item{posterior_args}{Optional list of graphical parameters for posterior lines/ribbons.}

\item{prior_args}{Optional list of graphical parameters for prior lines/ribbons.}

\item{...}{Other graphical parameters for the real data lines.}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
Plots panels of cumulative distribution functions (CDFs) for each level of the specified
defective factor in the data. The CDFs are \emph{defective}; each factor level's CDF
scales only up to that level's proportion. Summed across levels, the maximum is 1.
Optionally, posterior and/or prior predictive CDFs can be overlaid.
}
\examples{
# Plot defective CDF for data only
# plot_cdf(forstmann, to_plot = "data")
#
# Plot with posterior predictions
# plot_cdf(samples_LNR, to_plot = c("data","posterior"), n_post=10)
#
# Or a list of multiple emc objects ...
}
