% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglk_full.R
\name{loglk_full}
\alias{loglk_full}
\title{Full log-likelihood function}
\usage{
loglk_full(dat, zm, pi, mu, sigma, ncov = 2, xi)
}
\arguments{
\item{dat}{An \eqn{n\times p} matrix where each row represents an individual observation}

\item{zm}{An n-dimensional vector of group partition including the missing-label, denoted as NA.}

\item{pi}{A g-dimensional  initial vector of the mixing proportions.}

\item{mu}{A initial  \eqn{p \times g} matrix of the location parameters.}

\item{sigma}{A \eqn{p\times p} covariance matrix if \code{ncov=1}, or a list of g covariance matrices with dimension \eqn{p\times p \times g} if \code{ncov=2}.}

\item{ncov}{Options of structure of sigma matrix;  the default value is 2;
\code{ncov} = 1 for a common covariance matrix;
\code{ncov} = 2 for the unequal  covariance/scale matrices.#'}

\item{xi}{A 2-dimensional coefficient vector for a logistic function of the Shannon entropy.}
}
\value{
\item{lk}{Log-likelihood value}
}
\description{
Full log-likelihood function with both terms of ignoring and missing
}
\details{
The full log-likelihood function can be expressed as
\deqn{
\log L_{PC}^{({full})}(\boldsymbol{\Psi})=\log L_{PC}^{({ig})}(\theta)+\log L_{PC}^{({miss})}(\theta,\boldsymbol{\xi}),}
where\eqn{\log L_{PC}^{({ig})}(\theta)}is the log likelihood function formed ignoring the missing in the label of the unclassified features,
and \eqn{\log L_{PC}^{({miss})}(\theta,\boldsymbol{\xi})} is the log likelihood function formed on the basis of the missing-label indicator.
}
