% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EScvtmle.R
\name{ES.cvtmle}
\alias{ES.cvtmle}
\title{ES.cvtmle}
\usage{
ES.cvtmle(
  txinrwd,
  data,
  study,
  covariates,
  treatment_var,
  treatment,
  outcome,
  NCO = NULL,
  Delta = NULL,
  Delta_NCO = NULL,
  pRCT,
  V = 10,
  Q.SL.library,
  d.SL.library,
  g.SL.library,
  Q.discreteSL,
  d.discreteSL,
  g.discreteSL,
  family,
  family_nco,
  fluctuation = "logistic",
  comparisons = list(c(1), c(1, 2)),
  adjustnco = FALSE,
  target.gwt = TRUE,
  bounds = NULL
)
}
\arguments{
\item{txinrwd}{Whether active treatment is available in RWD (TRUE/FALSE). If FALSE, only the control arm of the RCT will be augmented with external data.}

\item{data}{The dataset}

\item{study}{Character name of variable indicating study participation (e.g. "S"). This variable should take a value of 1 for the RCT and should take other values for the other study(ies). Note that the code is currently set up only to handle two studies, but may be expanded to handle multiple studies in the future.}

\item{covariates}{Vector of character names of covariates to be adjusted for (e.g. c("W1", "W2"))}

\item{treatment_var}{Character name of treatment variable (e.g. "A")}

\item{treatment}{Value of treatment variable that corresponds to the active treatment (e.g. "DrugName" or 1). All other values of the treatment variable are assumed to be control.}

\item{outcome}{Character name of outcome variable (e.g. "Y"). If the outcome is a binary variable subject to censoring, censored observations should either be coded as NA or should be coded as 0 and a missingness indicator should be included (see parameter Delta below).}

\item{NCO}{Character name of negative control outcome variable (e.g. "nco") or NULL if no NCO available. If the NCO is a binary variable subject to censoring, censored observations should either be coded as NA or should be coded as 0 and a missingness indicator should be included (see parameter Delta_NCO below).}

\item{Delta}{Character name of a variable that is 0 if an observation was censored (missing outcome) and 1 otherwise. Missing outcomes may also be coded as NA, in which case a Delta variable will be added internally. If no missing outcomes, set Delta=NULL.}

\item{Delta_NCO}{Character name of a variable that is 0 if the value of NCO is missing and 1 otherwise. Missing NCOs may also be coded as NA, in which case a Delta_NCO variable will be added internally. If no missing NCO or no NCO, set Delta_NCO=NULL.}

\item{pRCT}{The probability of randomization to treatment in the RCT}

\item{V}{Number of cross-validation folds (default 10)}

\item{Q.SL.library}{Candidate algorithms for SuperLearner estimation of outcome regressions}

\item{d.SL.library}{Candidate algorithms for SuperLearner estimation of missingness mechanism}

\item{g.SL.library}{Candidate algorithms for SuperLearner estimation of treatment mechanism for combined RCT/RWD analysis}

\item{Q.discreteSL}{Should a discrete SuperLearner be used for estimation of outcome regressions? (TRUE/FALSE)}

\item{d.discreteSL}{Should a discrete SuperLearner be used for estimation of missingness mechanism? (TRUE/FALSE)}

\item{g.discreteSL}{Should a discrete SuperLearner be used for estimation of treatment mechanism? (TRUE/FALSE)}

\item{family}{Either "binomial" for binary outcomes or "gaussian" for continuous outcomes}

\item{family_nco}{Family for negative control outcome}

\item{fluctuation}{'logistic' (default for binary and continuous outcomes), or 'linear' describing fluctuation for targeted maximum likelihood estimation (TMLE) updating. If 'logistic' with a continuous outcome, outcomes are scaled to (0,1) for TMLE targeting and then returned to the original scale for parameter estimation.}

\item{comparisons}{A list of the values of the study variable that you would like to compare. For example, if you have an RCT labeled S=1 and RWD labeled S=2, you would use comparisons = list(c(1),c(1,2)) to compare RCT only to RCT + RWD. The first element of comparisons must be c(1) for the RCT only.}

\item{adjustnco}{Should we adjust for the NCO as a proxy of bias in the estimation of the ATE of A on Y? (TRUE/FALSE). Default is FALSE.}

\item{target.gwt}{As in the tmle R package (Gruber & van der Laan, 2012), if target.gwt is TRUE, the treatment mechanism is moved from the denominator of the clever covariate to the weight when fitting the coefficient for TMLE updating. Default TRUE.}

\item{bounds}{Optional bounds for truncation of the denominator of the clever covariate. The default is c(5/sqrt(n)/log(n),1).}
}
\value{
Returns an object of class "EScvtmle" that is a list with the following components.
\describe{
 \item{ATE}{Average treatment effect (ATE) point estimates for the ES-CVTMLE estimator using the estimated bias squared plus variance selector ("b2v") and for the selector that includes an estimate of the ATE on a negative control outcome (NCO) in the bias term of the selector ("ncobias") if an NCO is available.}
 \item{foldATEs}{Average treatment effect (ATE) point estimates for each cross-validation fold of the ES-CVTMLE estimator using the estimated bias squared plus variance selector ("b2v") and for the selector that includes an estimate of the ATE on a negative control outcome (NCO) in the bias term of the selector ("ncobias") if an NCO is available.}
 \item{g}{g is a list of the same length as comparisons where each element of the list is a vector of the denominator of the covariate in front of the residual in the efficient influence curve for all observations in the experiment described by that element of comparisons. Values of g close to 0 or 1 indicate practical near-positivity violations.}
 \item{CI}{Estimated 95\% confidence intervals for the average treatment effect estimates of the ES-CVTMLE estimator using the estimated bias squared plus variance selector ("b2v") and for the selector that includes an estimate of the ATE on a negative control outcome (NCO) in the bias term of the selector ("ncobias") if an NCO is available.}
 \item{limitdistributionsample}{Monte Carlo samples for the average treatment effect estimates of the ES-CVTMLE estimator that are used to construct confidence intervals for the estimated bias squared plus variance selector ("b2v") and for the selector that includes an estimate of the ATE on a negative control outcome (NCO) in the bias term of the selector ("ncobias") if an NCO is available.}
 \item{Var}{Estimated variance of the ES-CVTMLE average treatment effect estimator using the estimated bias squared plus variance selector ("b2v") and for the selector that includes an estimate of the ATE on a negative control outcome (NCO) in the bias term of the selector ("ncobias") if an NCO is available.}
 \item{selected_byfold}{Vector noting which experiment from the list of comparisons was selected in each cross-validation fold of the ES-CVTMLE estimator using the estimated bias squared plus variance selector ("b2v") and for the selector that includes an estimate of the ATE on a negative control outcome (NCO) in the bias term of the selector ("ncobias") if an NCO is available.}
 \item{proportionselected}{Proportion of all cross-validation folds in which real-world (external) data were included in the analysis for the ES-CVTMLE estimator using the estimated bias squared plus variance selector ("b2v") and for the selector that includes an estimate of the ATE on a negative control outcome (NCO) in the bias term of the selector ("ncobias") if an NCO is available.}
}
}
\description{
This function runs the experiment-selector cross-validated targeted maximum likelihood estimator (ES-CVTMLE) (Dang et al. 2022) for selecting and analyzing an optimal experiment, where candidate experiments include a randomized controlled trial (RCT) with or without various real-world datasets (RWD).
}
\details{
The experiment selector cross-validated targeted maximum likelihood estimator (ES-CVTMLE) aims to select the experiment that optimizes the bias-variance tradeoff for estimating a causal average treatment effect where different experiments may include a randomized controlled trial (RCT) alone or an RCT combined with real-world data.
Using cross-validation, the ES-CVTMLE separates the selection of the optimal experiment from the estimation of the ATE for the chosen experiment.
In order to avoid positivity violations, the package internally trims RWD so that no baseline covariate values are not represented in the RCT if active treatment is not available in the RWD.
The estimated bias term in the selector is a function of the difference in conditional mean outcome under control for the RCT compared to the combined experiment.
In order to help include truly unbiased external data in the analysis, the estimated average treatment effect on a negative control outcome may be added to the bias term in the selector by setting the parameter NCO to the character name of a negative control variable in the dataset.
For more details about this method, please see Dang et al. (2022).

References:

Dang LE, Tarp JM, Abrahamsen TJ, Kvist K, Buse JB, Petersen M, van der Laan M (2022). A Cross-Validated Targeted Maximum Likelihood Estimator for Data-Adaptive Experiment Selection Applied to the Augmentation of RCT Control Arms with External Data. arXiv:2210.05802 [stat.ME]

Susan Gruber, Mark J. van der Laan (2012). tmle: An R Package for Targeted Maximum Likelihood Estimation. Journal of Statistical Software, 51(13), 1-35. URL <http://www.jstatsoft.org/v51/i13/>.
}
\examples{
\donttest{data(wash)
#For unbiased external controls, use:
dat <- wash[which(wash$study \%in\% c(1,2)),]
set.seed(2022)
results_rwd1 <- ES.cvtmle(txinrwd=TRUE,
                          data=dat, study="study",
                          covariates=c("aged", "sex", "momedu", "hfiacat"),
                          treatment_var="treatment", treatment=1,
                          outcome="laz", NCO="Nlt18scale",
                          Delta=NULL, Delta_NCO=NULL,
                          pRCT=0.5, V=5, Q.SL.library=c("SL.glm"),
                          g.SL.library=c("SL.glm"), Q.discreteSL=TRUE, g.discreteSL=TRUE,
                          family="gaussian", family_nco="gaussian", fluctuation = "logistic",
                          comparisons = list(c(1),c(1,2)), adjustnco = FALSE, target.gwt = TRUE)
print.EScvtmle(results_rwd1)
}

}
