% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conda_clean.R
\name{conda_clean}
\alias{conda_clean}
\title{Python Removal}
\usage{
conda_clean(envname, conda_path = reticulate::miniconda_path(), auto = FALSE)
}
\arguments{
\item{envname}{A string naming the desired Python environment to create/activate. If no Python or environment found, the functions prompts to install miniconda and the required python packages.}

\item{conda_path}{The location of Python install. By default, this follows \code{minicondata_path} defined by the \code{reticulate} package.}

\item{auto}{Boolean. If \code{FALSE}, asks permission to uninstall Python, packages and specified environment. If \code{TRUE}, no user confirmation is required for activation.}
}
\value{
Does not return an object as is cleaning Python and its environments.
}
\description{
Removes \code{ewsnet_init()} downloaded Anaconda binaries and environmnets.
}
\examples{
#Prior to running `conda_clean()`, you must restart
#your R session to detach any activated environments
\donttest{
conda_clean("EWSNET_env", auto = TRUE)
}

}
