% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FPR4AM.R
\name{FPR4AM}
\alias{FPR4AM}
\title{Set the false positive rate for \code{AM}}
\usage{
FPR4AM(falseposrate = 0.05, trait = trait, numreps = 100,
  fformula = NULL, availmemGb = 8, numgammas = 20, geno = NULL,
  pheno = NULL, map = NULL, Zmat = NULL, ncpu = detectCores(),
  ngpu = 0, seed = 101)
}
\arguments{
\item{falseposrate}{the desired false positive rate.}

\item{trait}{the name of the column in the phenotype data file that contains the trait data. The name is case sensitive and must match exactly the column name in the phenotype data file.  This parameter must be specified.}

\item{numreps}{the number of replicates upon which to base the calculation of the false 
positive rate. We have found 100 replicates to be sufficient.}

\item{fformula}{the right hand side formula for the fixed effects part of the model.}

\item{availmemGb}{a numeric value. It specifies the amount of available memory (in Gigabytes). 
This should be set to the maximum practical value of available memory for the analysis.}

\item{numgammas}{the number of equidistant gamma values from 0 to 1 for which to calculate the false positive rate of the model building process. This should not need 
adjusting.}

\item{geno}{the R  object obtained from running \code{\link{ReadMarker}}. This must be specified.}

\item{pheno}{the R  object  obtained  from running \code{\link{ReadPheno}}. This must be specified.}

\item{map}{the R object obtained from running \code{\link{ReadMap}}. If not specified, a generic map will 
be assumed.}

\item{Zmat}{the R object obtained from running \code{\link{ReadZmat}}. If not specified, an identity matrix will be assumed.}

\item{ncpu}{a integer  value for the number of CPU that are available for distributed computing.  The default is to determine the number of CPU automatically.}

\item{ngpu}{a integer value for the number of gpu available for computation.  The default
is to assume there are no gpu available.  
This option has not yet been implemented.}

\item{seed}{a integer value for the starting seed for the permutations.}
}
\value{
A list with the following components:
\describe{
\item{numreps:}{the number of permutations performed.}
\item{gamma:}{the vector of gamma values.}
\item{falsepos:}{the false positive rates for the gamma values.}
\item{setgamma:}{the gamma value that gives a false positive rate of \code{falseposrate} }
}
}
\description{
The gamma parameter in \code{AM} controls the false positive rate of the model 
building process. This function uses permutation to  find the gamma value for a desired false positive rate.
}
\details{
The false positive rate for \code{\link{AM}} is controlled by its gamma parameter. Values close to 
1 (0) decreases (increases) the false positive rate of detecting SNP-trait associations. There is no 
analytical way of setting gamma for a specified false positive rate. So we are using permutation to do this empirically. 

By setting \code{falseposrate} to the desired false positive rate, this function will find the corresponding gamma value for \code{\link{AM}}. 

A table of other gamma values for a range of false positive rates is also given. 

To increase the precision of the gamma estimates, increase \code{numreps}.
}
\examples{
  \dontrun{ 
  # Since the following code takes longer than 5 seconds to run, it has been tagged as dontrun. 
  # However, the code can be run by the user. 
  #

  #-------------------------
  #  Example  
  #------------------------

  # read the map 
  #~~~~~~~~~~~~~~
  
  # File is a plain space separated text file with the first row 
  # the column headings
  complete.name <- system.file('extdata', 'map.txt', 
                                   package='Eagle')
  map_obj <- ReadMap(filename=complete.name) 

  # read marker data
  #~~~~~~~~~~~~~~~~~~~~
  # Reading in a PLINK ped file 
  # and setting the available memory on the machine for the reading of the data to 8  gigabytes
  complete.name <- system.file('extdata', 'geno.ped', 
                                     package='Eagle')
  geno_obj <- ReadMarker(filename=complete.name,  type='PLINK', availmemGb=8) 
 
  # read phenotype data
  #~~~~~~~~~~~~~~~~~~~~~~~

  # Read in a plain text file with data on a single trait and two covariates
  # The first row of the text file contains the column names y, cov1, and cov2. 
  complete.name <- system.file('extdata', 'pheno.txt', package='Eagle')
  
  pheno_obj <- ReadPheno(filename=complete.name)
           

 #  Suppose we want to perform the AM analysis at a 5\% false positive rate. 
 #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 
  ans <- FPR4AM(falseposrate = 0.05,
                trait = 'y',
                fformula=c('cov1+cov2'),
                map = map_obj,
                pheno = pheno_obj,
                geno = geno_obj) 
 

  res <- AM(trait =  'y',
                fformula=c('cov1+cov2'),
                map = map_obj,
                pheno = pheno_obj,
                geno = geno_obj,
                gamma = ans$setgamma)


}


}
\seealso{
\code{\link{AM}}
}
