% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.genepop2df.R
\name{eco.genepop2df}
\alias{eco.genepop2df}
\title{Importing a Genepop file}
\usage{
eco.genepop2df(genefile = NULL)
}
\arguments{
\item{genefile}{Genepop file.}
}
\value{
A list with the objects G (genetic matrix) and S (structures matrix).
}
\description{
This function converts a Genepop file into an object 
with a genetic matrix (G) and a structures matrix (S).
}
\examples{
\dontrun{
# ingpop, file with Genepop format in the folder "/extdata" of the package

ecopath <- paste(path.package("EcoGenetics"), "/extdata/ingpop", sep = "")
ingpop <- eco.genepop2df(ecopath)
ingpop
}

}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}, adapting code
written by Emiel van Loon and Scott Davis
}

