% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.variogram.R
\name{eco.variogram}
\alias{eco.variogram}
\title{Empirical variogram}
\usage{
eco.variogram(Z, XY, int = NULL, smin = 0, smax = NULL, nclass = NULL,
  seqvec = NULL, size = NULL, bin = c("sturges", "FD"), row.sd = FALSE,
  latlon = FALSE)
}
\arguments{
\item{Z}{Vector for the analysis.}

\item{XY}{Data frame or matrix with individual's position (projected coordinates).}

\item{int}{Distance interval in the units of XY.}

\item{smin}{Minimum class distance in the units of XY.}

\item{smax}{Maximum class distance iin the units of XY.}

\item{nclass}{Number of classes.}

\item{seqvec}{Vector with breaks in the units of XY.}

\item{size}{Number of individuals per class.}

\item{bin}{Rule for constructing intervals when a partition parameter (int, 
nclass or size) is not given. Default is Sturge's rule (Sturges, 1926). Other
option is Freedman-Diaconis method (Freedman and Diaconis, 1981).}

\item{row.sd}{Logical. Should be row standardized the matrix? Default FALSE 
(binary weights).}

\item{latlon}{Are the coordinates in decimal degrees format? Defalut FALSE. If TRUE,
the coordinates must be in a matrix/data frame with the longitude in the first
column and latitude in the second. The position is projected onto a plane in
meters with the function \code{\link[SoDA]{geoXY}}.}
}
\value{
The program returns an object of class "eco.correlog" 
with the following slots:

> OUT analysis output

> IN analysis input data

> BEAKS breaks

> CARDINAL number of elements in each class

> DISTMETHOD method used in the construction of breaks


\strong{ACCESS TO THE SLOTS}
The content of the slots can be accessed 
with the corresponding accessors, using
the generic notation of EcoGenetics 
(<ecoslot.> + <name of the slot> + <name of the object>).
See help("EcoGenetics accessors") and the Examples
section below
}
\description{
This program computes the empirical variogram of a selected variable.
If the coordinates are given in decimal degrees, set latlon = TRUE. The program
return a table with the mean class distances (d.mean) and the semivariances (obs)
for each class.
}
\examples{
\dontrun{

data(eco.test)
variog <- eco.variogram(Z = eco[["P"]][, 2],XY =  eco[["XY"]])
plot(variog)

# variogram plots support the use of ggplot2 syntax
variogplot <- plot(variog) + theme_bw() + theme(legend.position="none")
variogplot

#-----------------------
# ACCESSORS USE EXAMPLE
#-----------------------

# the slots are accessed with the generic format 
# (ecoslot. + name of the slot + name of the object). 
# See help("EcoGenetics accessors")

ecoslot.OUT(variog)        # slot OUT
ecoslot.BREAKS(variog)     # slot BREAKS

}

}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}
\references{
Borcard D., F. Gillet, and P. Legendre. 2011. Numerical ecology with R. 
Springer Science & Business Media.

Legendre P., and L. Legendre. 2012. Numerical ecology. Third English edition.
Elsevier Science, Amsterdam, Netherlands.
}

