% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/coccurrence_null.R
\name{cooc_null_model}
\alias{cooc_null_model}
\title{Co-Occurrence Null model}
\usage{
cooc_null_model(speciesData, algo = "sim9", metric = "c_score",
  nReps = 1000, saveSeed = FALSE, burn_in = 500, algoOpts = list(),
  metricOpts = list(), suppressProg = FALSE)
}
\arguments{
\item{speciesData}{a dataframe in which rows are species, columns are sites,
and the entries indicate the absence (0) or presence (1) of a species in a
site. Empty rows and empty columns should not be included in the matrix.}

\item{algo}{the algorithm to use, must be "sim1", "sim2", "sim3", "sim4", "sim5", "sim6", "sim7", "sim8", "sim9", "sim10"; default is "sim9".}

\item{metric}{the metric used to calculate the null model: choices are "species_combo", "checker", "c_score", "c_score_var", "c_score_skew", "v_ratio"; default is "c_score".}

\item{nReps}{the number of replicate null assemblages to create; default is 1000 replicates.}

\item{saveSeed}{TRUE or FALSE. If TRUE the current seed is saved so the simulation can be repeated; default is FALSE.}

\item{burn_in}{The number of burn_in iterations to use with the simFast algorithm; default is 500 burn-in replicates.}

\item{algoOpts}{a list containing all the options for the specific algorithm you want to use.  Must match the algorithm given in the `algo` argument.}

\item{metricOpts}{a list containing all the options for the specific metric you want to use.  Must match the metric given in the `metric` argument.}

\item{suppressProg}{TRUE or FALSE. If true, display of the progress bar in the console is suppressed; default is FALSE. This setting is useful for creating markdown documents with `knitr`.}
}
\description{
Create a Co-Occurrence null model
}
\examples{
\dontrun{

## Run the null model
finchMod <- cooc_null_model(dataWiFinches, algo="sim9",nReps=10000,burn_in = 500)
## Summary and plot info
summary(finchMod)
plot(finchMod,type="burn_in")
plot(finchMod,type="hist")
plot(finchMod,type="cooc")

## Example that is repeatable with a saved seed
finchMod <- cooc_null_model(dataWiFinches, algo="sim1",saveSeed = TRUE)
mean(finchMod$Sim)
## Run the model with the seed saved

finchMod <- cooc_null_model(dataWiFinches, algo="sim1",saveSeed=T)
## Check model output
mean(finchMod$Sim)

reproduce_model(finchMod$Sim)

finchMod <- cooc_null_model(dataWiFinches, algo="sim1")
## Check model output is the same as before
mean(finchMod$Sim)
reproduce_model(finchMod$Sim)


}
}

