% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/null_model_engine.R
\name{null_model_engine}
\alias{null_model_engine}
\title{Run null model}
\usage{
null_model_engine(speciesData, algo, metric, nReps = 1000, saveSeed = FALSE,
  algoOpts = list(), metricOpts = list(), type = NULL,
  suppressProg = FALSE)
}
\arguments{
\item{speciesData}{a dataframe for analysis that is compatable with the metrics and algorithms used.}

\item{algo}{the algorithm used to randomize the data.}

\item{metric}{the metric used to quantify pattern in the data.}

\item{nReps}{the number of null assemblages to simulate.}

\item{saveSeed}{Save the existing random seed to allow the user to reproduce the exact model results. The default value is FALSE, in which case the random number seed that is created is not stored in the output.}

\item{algoOpts}{a list containing options for a supplied alogrithm.}

\item{metricOpts}{a list containing options for a supplied metric.}

\item{type}{The type of null model being run. If the null model is intended to be used with one of the existing modules, the type should be "size","niche", or "cooc". If the user is creating an entirely new null model, type should be set to NULL (the default value).}

\item{suppressProg}{TRUE or FALSE. If true, display of the progress bar in the console is suppressed; default is FALSE. This setting is useful for creating markdown documents with `knitr`.}
}
\description{
This function drives all the different kinds of null models that can be run. It is the underlying engine.
}
\examples{
\dontrun{
# User defined function


}
}

