\name{create.ETmain}
\alias{create.ETmain}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Create ET-Main (ET-Transpose routine) 
}
\description{
This function enables the creation of the ET-Main table (summarizing the principal results/variables in function of the TL classes) and other intermediate tables of the ET-Transpose routine. It provides a picture of an ecosystem under a given fishing mortality.
}
\usage{
create.ETmain(ecopath, smooth_type=NULL, sigmaLN_cst=NULL,
	pas=NULL, shift=NULL, smooth_param=NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{ecopath}{
is the input table used in ET (possibly based on Ecopath data). The different variables are the group name, its trophic level, biomass, production, catches, omnivory index and accessibility (fraction of the group that can be catch assuming an infinite fishing effort).
}
  \item{smooth_type}{
is a parameter of the create.smooth function. It defines the type of sigma calculation for the lognormal distribution. The value for this parameter is 1, 2 or 3. By default smooth_type=1, this defines a constant sigma. By choosing smooth_type=2, the user has the possibility to put a sigmaLN=smooth_param*ln(TL-0.05), with smooth_param=0.07 and shift=0.95 by default. Smooth_type=3 corresponds to the use of the calculated Omnivory Index (OI) divided by the associated mean TL as sigmaLN.
}
  \item{sigmaLN_cst}{
is a parameter of the create.smooth function. It defines the value of the constant sigma of the lognormal distribution for smooth_type=1. By default, sigmaLN_cst=0.12.
}
  \item{pas}{
is a parameter of the create.smooth function. It defines the splitting of the TL classes. 
}
  \item{shift}{
is a parameter of the create.smooth function. It defines the beginning of the smooth function and allows the substraction of 0.05 in the sigma calculation accounting for the half interval range of the trophic class.
}
  \item{smooth_param}{
is a parameter of the create.smooth function. It defines the slope of the log-linearly increase of the TL variability with the mean trophic level of the group for smooth_type=2. 
SigmaLN(TL) is thus defined as sigmaLN(TL)=smooth_param*ln(TL-0.05).
}
}
\value{
This function returns a list containing: the ET-Main table, intermediate matrices (biomass, accessible biomass, flowP...) and a list of matrices corresponding to the different fisheries catches.
}
\author{
Colleter Mathieu, Guitton Jerome and Gatti Paul.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
plot.ETmain to create the principle graphics resulting from the create.ETmain function, create.smooth to create the Smooth table used in this function, Transpose to convert data referring to groups into data referring to TL classes.
}
\examples{
data(ecopath_guinee)
create.ETmain(ecopath_guinee)
#Use of the second smooth type
create.ETmain(ecopath_guinee,smooth_type=2)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~EcoTroph }
\keyword{ ~Transpose }
