% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readHSB_SR.R
\name{readHSB_Senior}
\alias{readHSB_Senior}
\title{Connect to HS&B Study Senior Data}
\usage{
readHSB_Senior(
  HSR8086_PRI_FilePath,
  HSR8086_SASSyntax_Path,
  forceReread = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{HSR8086_PRI_FilePath}{a character value to the main study-derived
analytical data file (HSR8086_REV.PRI).
Located within the \code{REVISED_ASCII} Folder.}

\item{HSR8086_SASSyntax_Path}{a character value to the SAS syntax file for
parsing the \code{HSR8086_REV.PRI} data file.
Located within the \code{SAS_EXTRACT_LOGIC} Folder.}

\item{forceReread}{a logical value to force rereading of all processed data.
The default value of \code{FALSE} will speed up the read
function by using existing read-in data already processed.}

\item{verbose}{a logical value that will determine if you want verbose output
while the \code{readHSB_Senior} function is running to
indicate processing progress. The default value is \code{TRUE}.}
}
\value{
an \code{edsurvey.data.frame} for the HS&B Senior 1980--1986 longitudinal dataset
}
\description{
Opens a connection to a High School & Beyond 1980--1986 Senior cohort data file and
             returns an \code{edsurvey.data.frame} with 
             information about the file and data.
}
\details{
Reads in the specified \code{HSR8086_SASSyntax_Path} file to parse
the \code{HSR8086_PRI_FilePath} file.
A cached data file and metadata file will be saved in the same
directory and filename as the \code{HSR8086_PRI_FilePath} file,
having new file extensions of .txt and .meta, respectively.  
         
Please note the original source \code{repcode} variable has been split
into two variables named \code{repcode_str} for the stratum value
and \code{repcode_psu} for the primary sampling unit (PSU) value in the resulting
cache data.
}
\examples{
\dontrun{
setwd("C:/B&B2003/ecbw/B03")

dasFP <- file.path(getwd(), "Data", "B03DAS.dat")
wgtFP <- file.path(getwd(), "Data", "B03WEIGHT.dat")
mstFP <- file.path(getwd(), "master.txt")

# with verbose output as default
bb2003 <- readBB_2003(dasFP, wgtFP, mstFP)

# silent output
bb2003 <- readBB_2003(dasFP, wgtFP, mstFP, verbose=FALSE)

# force data cache update
bb2003 <- readBB_2003(dasFP, wgtFP, mstFP, forceReread = TRUE)
}
}
\seealso{
\code{\link{readECLS_K2011}}, \code{\link{readNAEP}}, and \code{\link{getData}}
}
\author{
Tom Fink
}
