% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenR.R
\name{Eigen_chol}
\alias{Eigen_chol}
\title{Cholesky decomposition of a matrix}
\usage{
Eigen_chol(M)
}
\arguments{
\item{M}{a square symmetric/Hermitian positive-definite matrix or 
\code{\link{SparseMatrix}}, real/complex}
}
\value{
The upper triangular factor of the Cholesky decomposition of 
  \code{M}.
}
\description{
Cholesky decomposition of a symmetric or Hermitian matrix.
}
\details{
Symmetry is not checked; only the lower triangular part of 
  \code{M} is used.
}
\examples{
M <- rbind(c(5,1), c(1,3))
U <- Eigen_chol(M)
t(U) \%*\% U # this is `M`
# a Hermitian example:
A <- rbind(c(1,1i), c(1i,2))
( M <- A \%*\% t(Conj(A)) )
try(chol(M)) # fails
U <- Eigen_chol(M) 
t(Conj(U)) \%*\% U # this is `M`
# a sparse example
M <- asSparseMatrix(diag(1:5))
Eigen_chol(M)
}
