% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EleChemr.R
\name{CVEC}
\alias{CVEC}
\title{EC behaviour cyclic voltammetry simulator}
\usage{
CVEC(Co = 0.001, Dx = 1e-05, Eo = 0.1, Vi = 0.3, Vf = -0.3,
  Vs = 0.001, ko = 0.01, kc = 1e-04, alpha = 0.5, Temp = 298.15,
  n = 1, Area = 1, DerApprox = 2, errCheck = FALSE,
  Method = "Euler")
}
\arguments{
\item{Co}{bulk concentration}

\item{Dx}{diffusion coefficient}

\item{Eo}{reduction potential of the species}

\item{Vi}{initial potential of the sweep}

\item{Vf}{final potential of the sweep}

\item{Vs}{potential scan rate of the simulation}

\item{ko}{heterogeneous electron transfer rate constant}

\item{kc}{rate constant of the reaction Red -> C}

\item{alpha}{charge transfer coefficient}

\item{Temp}{temperature in kelvin}

\item{n}{number of electrons involved in the process}

\item{Area}{area of the electrode}

\item{DerApprox}{number of point for the approximation of the first derivative}

\item{errCheck}{if true the function returns a list with parameters for CottrCheck function}

\item{Method}{method to be used for the simulation = "Euler" "BI" "RK4"}
}
\value{
if errCheck == F a graph I vs E, if errCheck == T a list
}
\description{
Return a graph I vs E of the electrochemical process
}
\examples{
CVEC(Co = 0.001, DerApprox = 2, kc = 0.00001, errCheck = FALSE, Method = "Euler")

}
