% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericalAnalysis.R
\name{conv_funct}
\alias{conv_funct}
\alias{Convert_gd_To_g1}
\alias{Convert_g1_To_Fg1}
\alias{Convert_g1_To_Qg1}
\alias{Convert_g1_To_f1}
\alias{Convert_gd_To_fR2}
\title{Conversion Functions for Elliptical Distributions}
\usage{
Convert_gd_To_g1(grid, g_d, d)

Convert_g1_To_Fg1(grid, g_1)

Convert_g1_To_Qg1(grid, g_1)

Convert_g1_To_f1(grid, g_1)

Convert_gd_To_fR2(grid, g_d, d)
}
\arguments{
\item{grid}{the grid on which the values of the functions in parameter are given.}

\item{g_d}{the \eqn{d}-dimensional density generator.}

\item{d}{the dimension of the random vector.}

\item{g_1}{the \eqn{1}-dimensional density generator.}
}
\value{
One of the following \itemize{
\item g_1 the \eqn{1}-dimensional density generator.
\item Fg1 the \eqn{1}-dimensional marginal cumulative distribution function.
\item Qg1 the \eqn{1}-dimensional marginal quantile function
(approximatly equal to the inverse function of Fg1).
\item f1 the density of a \eqn{1}-dimensional margin if \eqn{\mu = 0}
and \eqn{A} is the identity matrix.
\item fR2 the density function of \eqn{R^2}.
}
}
\description{
An elliptical random vector X of density \eqn{|det(\Sigma)|^{-1/2} g_d(x' \Sigma^{-1} x)}
can always be written as \eqn{X = \mu + R * A * U} for some positive random variable \eqn{R}
and a random vector \eqn{U} on the \eqn{d}-dimensional sphere.
Furthermore, there is a one-to-one mapping between g_d
and its one-dimensional marginal g_1.
}
\examples{
grid = seq(0,100,by = 0.01)
g_d = DensityGenerator.normalize(grid = grid, grid_g = 1/(1+grid^3), d = 3)
g_1 = Convert_gd_To_g1(grid = grid, g_d = g_d, d = 3)
Fg_1 = Convert_g1_To_Fg1(grid = grid, g_1 = g_1)
Qg_1 = Convert_g1_To_Qg1(grid = grid, g_1 = g_1)
f1 = Convert_g1_To_f1(grid = grid, g_1 = g_1)
fR2 = Convert_gd_To_fR2(grid = grid, g_d = g_d, d = 3)
plot(grid, g_d, type = "l", xlim = c(0,10))
plot(grid, g_1, type = "l", xlim = c(0,10))
plot(Fg_1, xlim = c(-3,3))
plot(Qg_1, xlim = c(0.01,0.99))
plot(f1, xlim = c(-3,3))
plot(fR2, xlim = c(0,3))

}
\seealso{
\code{\link{DensityGenerator.normalize}}
to compute the normalized version of a given \eqn{d}-dimensional generator.
}
