% Generated by roxygen2 (4.0.2): do not edit by hand
\name{transco}
\alias{transco}
\title{Obtain Transparent Colors}
\usage{
transco(col, alpha = 1, invisible = FALSE)
}
\arguments{
\item{col}{a vector consisting of colors, of any of the three kinds of
\code{R} color specifications (named, hexadecimal, or integer; see
\code{\link{col2rgb}}).}

\item{alpha}{a vector of transparency levels, where 0 is transparent and 1
is opaque.}

\item{invisible}{supresses printing of the RGB color.}
}
\value{
A vector of length equal to the input \code{col} vector or the \code{alpha},
vector, if one or the other is of length greater than 1, containing the
transformed color values in hexidemical format.
}
\description{
Returns an RGB transparent color from any standard R color.
}
\details{
The purpose of this function is to facilitate color transparency, which is
used widely in \code{EpiModel} plots. This is an internal function that is
not ordinarily called by the end-user. This function allows that one of col
or alpha may be of length greater than 1.
}
\examples{
## Example 1: Bubble plot with multiple length color vector
n <- 25
x <- sort(sample(1:200, n))
y <- 10 + 2*x + rnorm(n, 0, 10)
z <- rpois(n, 10)
cols <- transco(c("steelblue", "black"), 0.5)
par(mar=c(2, 2, 1, 1))
plot(x, y, cex = z/4, pch = 21, col = "black",
     bg = cols[1], lwd = 1.2, axes = FALSE,
     ylim = c(0, 500), xlim = c(0, 250),
     yaxs = "r", xaxs = "r")
axis(2, seq(0, 500, 100), col = "white", las = 2,
    cex.axis = 0.9, mgp = c(2, 0.5, 0))
axis(1, seq(0, 250, 50), cex.axis = 0.9,
     mgp = c(2, 0.5, 0))
abline(h = seq(100, 500, 100), col = cols[2])

## Example 2: Network plot with multiple length alpha vector
net <- network.initialize(500, directed = FALSE)
vcol <- transco("firebrick",
                alpha = seq(0, 1, length = network.size(net)))
par(mar = c(0, 0, 0, 0))
plot(net, vertex.col = vcol, vertex.border = "grey70",
     vertex.cex = 1.5, edge.col = "grey50")
}
\seealso{
\code{\link{rgb}}, \code{\link{col2rgb}}
}
\keyword{colorUtils}
\keyword{internal}

