% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.mod.infection.R
\name{discord_edgelist}
\alias{discord_edgelist}
\title{Discordant Edgelist}
\usage{
discord_edgelist(dat, at, network = 1, infstat = "i")
}
\arguments{
\item{dat}{Main list object containing a \code{networkDynamic} object and
other initialization information passed from \code{\link{netsim}}.}

\item{at}{Current time step.}

\item{network}{In case of models with multiple networks, the network to pull
the current edgelist from. Default of \code{network = 1}.}

\item{infstat}{Character vector of disease status values that are considered
infectious, defining the SI pairs.}
}
\value{
This function returns a \code{data.frame} with the following columns:
\itemize{
 \item \strong{time:} time step queried.
 \item \strong{sus:} ID number for the susceptible partner.
 \item \strong{inf:} ID number for the infectious partner.
}
The output from this function is added to the transmission \code{data.frame}
object that is requested as output in \code{netsim} simulations with
the \code{save.trans=TRUE} argument.
}
\description{
This function returns a \code{data.frame} with a discordant
             edgelist, defined as the set of edges in which the status of the
             two partners is one susceptible and one infected.
}
\details{
This internal function works within the parent \code{\link{infection.net}}
function to pull the current edgelist from the dynamic network object, look
up the disease status of the head and tails on the edge, and subset the list
to those edges with one susceptible and one infected node.

EpiModel v2.0.3 extended the function by allowing flexibility in the
definition what disease status counts as infectious, with the \code{infstat}
parameter. For extension models with multiple infectious states, this can be
a vector of length greater than 1: \code{infstat = c("i", "a")}.
}
\seealso{
\code{\link{netsim}}, \code{\link{infection.net}}
}
\keyword{internal}
\keyword{netMod}
