% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{backcalc_opts}
\alias{backcalc_opts}
\title{Back Calculation Options}
\usage{
backcalc_opts(prior_window = 7, rt_window = 1)
}
\arguments{
\item{prior_window}{Integer, defaults to 7 days. The mean smoothing window to apply
to mean shifted reports (used as a prior during back calculation). 7 days is the default
as this smooths day of the week effects but depending on the quality of the data and the
amount of information users wish to use as a prior (higher values equalling a less informative prior).}

\item{rt_window}{Integer, defaults to 1. The size of the centred rolling average to use when estimating
Rt. This must be odd so that the central estimate is included.}
}
\value{
A list of back calculation settings
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}
Defines a list specifying the optional arguments for the back calculation
of cases. Only used if \code{rt = NULL}.
}
\examples{
# default settings
backcalc_opts()
}
