% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_stan_args}
\alias{create_stan_args}
\title{Create a List of Stan Arguments}
\usage{
create_stan_args(
  stan = stan_opts(),
  data = NULL,
  init = "random",
  verbose = FALSE
)
}
\arguments{
\item{stan}{A list of stan options as generated by \code{stan_opts()}. Defaults
to \code{stan_opts()}. Can be used to override \code{data}, \code{init}, and \code{verbose}
settings if desired.}

\item{data}{A list of stan data as created by \code{create_stan_data}}

\item{init}{Initial conditions passed to \code{rstan}. Defaults to "random" but
can also be a function (as supplied by \code{create_intitial_conditions}).}

\item{verbose}{Logical, defaults to \code{FALSE}. Should verbose progress
messages be returned.}
}
\value{
A list of stan arguments
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Generates a list of arguments as required by \code{rstan::sampling} or
\code{rstan::vb} by combining the required options, with data, and type of
initialisation. Initialisation defaults to random but it is expected that
\code{create_initial_conditions} will be used.
}
\examples{
# default settings
create_stan_args()

# increasing warmup
create_stan_args(stan = stan_opts(warmup = 1000))
}
\author{
Sam Abbott
}
